/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model;

import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.model.ColorGroup;
import charactermanaj.model.ColorInfo;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsColorInfo;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSpec;
import charactermanaj.model.PartsSpecResolver;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartsColorManager {
    private static final Logger logger = Logger.getLogger(PartsColorManager.class.getName());
    private HashMap<PartsIdentifier, PartsColorInfo> partsColorInfoMap = new HashMap();
    private HashMap<PartsCategory, CategoryColorInfo> categoryColorInfoMap = new HashMap();
    private HashMap<ColorGroup, ColorConvertParameter> recentColorGroupMap = new HashMap();
    private PartsSpecResolver partsSpecResolver;

    public PartsColorManager(PartsSpecResolver partsSpecResolver) {
        if (partsSpecResolver == null) {
            throw new IllegalArgumentException();
        }
        this.partsSpecResolver = partsSpecResolver;
    }

    public PartsColorInfo getPartsColorInfo(PartsIdentifier partsIdentifier, boolean registered) {
        if (partsIdentifier == null) {
            throw new IllegalArgumentException();
        }
        PartsColorInfo partsColorInfo = this.partsColorInfoMap.get(partsIdentifier);
        if (partsColorInfo == null) {
            partsColorInfo = this.createDefaultColorInfo(partsIdentifier);
            if (registered) {
                this.partsColorInfoMap.put(partsIdentifier, partsColorInfo);
            }
        }
        return partsColorInfo;
    }

    public void setPartsColorInfo(PartsIdentifier partsIdentifier, PartsColorInfo partsColorInfo, boolean applyAll) {
        if (partsIdentifier == null || partsColorInfo == null) {
            throw new IllegalArgumentException();
        }
        partsColorInfo = partsColorInfo.clone();
        PartsCategory partsCategory = partsIdentifier.getPartsCategory();
        if (applyAll) {
            this.resetPartsColorInfo(partsCategory);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "setPartsColorInfo(Category): " + partsIdentifier + "=" + partsColorInfo);
            }
        } else {
            this.partsColorInfoMap.put(partsIdentifier, partsColorInfo);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "setPartsColorInfo(Parts): " + partsIdentifier + "=" + partsColorInfo);
            }
        }
        if (applyAll) {
            this.setRecentColorGroup(partsColorInfo);
        }
        CategoryColorInfo categoryColorInfo = this.categoryColorInfoMap.get(partsCategory);
        if (applyAll || !partsCategory.isMultipleSelectable() && (categoryColorInfo == null || !categoryColorInfo.isApplyAll())) {
            categoryColorInfo = new CategoryColorInfo(partsColorInfo, applyAll);
            this.categoryColorInfoMap.put(partsCategory, categoryColorInfo);
        }
    }

    protected void setRecentColorGroup(PartsColorInfo partsColorInfo) {
        if (partsColorInfo == null) {
            return;
        }
        for (Map.Entry<Layer, ColorInfo> entry : partsColorInfo.entrySet()) {
            ColorInfo colorInfo = entry.getValue();
            ColorGroup colorGroup = colorInfo.getColorGroup();
            if (!colorInfo.isSyncColorGroup() || colorGroup == null || !colorGroup.isEnabled()) continue;
            ColorConvertParameter colorParam = colorInfo.getColorParameter();
            if (colorParam != null) {
                colorParam = colorParam.clone();
            }
            ColorConvertParameter oldColorParam = this.recentColorGroupMap.put(colorGroup, colorParam);
            if (!logger.isLoggable(Level.FINEST) || ColorConvertParameter.equals(colorParam, oldColorParam)) continue;
            logger.log(Level.FINEST, "setRecentColorGroup(" + colorGroup + ")=" + colorParam);
        }
    }

    protected ColorConvertParameter getRecentColorGroup(ColorGroup colorGroup) {
        if (colorGroup == null || !colorGroup.isEnabled()) {
            return null;
        }
        ColorConvertParameter colorParam = this.recentColorGroupMap.get(colorGroup);
        if (colorParam != null) {
            colorParam = colorParam.clone();
        }
        return colorParam;
    }

    public CategoryColorInfo getPartsColorInfo(PartsCategory partsCategory) {
        return this.categoryColorInfoMap.get(partsCategory);
    }

    public void resetPartsColorInfo() {
        this.resetPartsColorInfo(null);
    }

    public void resetPartsColorInfo(PartsCategory partsCategory) {
        if (partsCategory == null) {
            this.recentColorGroupMap.clear();
            this.partsColorInfoMap.clear();
            this.categoryColorInfoMap.clear();
            return;
        }
        this.categoryColorInfoMap.remove(partsCategory);
        Iterator<Map.Entry<PartsIdentifier, PartsColorInfo>> ite = this.partsColorInfoMap.entrySet().iterator();
        while (ite.hasNext()) {
            Map.Entry<PartsIdentifier, PartsColorInfo> entry = ite.next();
            PartsIdentifier partsIdentifier = entry.getKey();
            if (!partsIdentifier.getPartsCategory().equals(partsCategory)) continue;
            ite.remove();
        }
    }

    protected PartsColorInfo createDefaultColorInfo(PartsIdentifier partsIdentifier) {
        Object colorInfo;
        PartsCategory category = partsIdentifier.getPartsCategory();
        PartsColorInfo partsColorInfo = new PartsColorInfo(category);
        PartsSpec partsSpec = this.partsSpecResolver.getPartsSpec(partsIdentifier);
        ColorGroup partsSpecColorGroup = null;
        if (partsSpec != null) {
            partsSpecColorGroup = partsSpec.getColorGroup();
        }
        if (partsSpecColorGroup != null && partsSpecColorGroup.isEnabled()) {
            for (Map.Entry<Layer, ColorInfo> entry : partsColorInfo.entrySet()) {
                colorInfo = entry.getValue();
                colorInfo = ((ColorInfo)colorInfo).clone();
                ((ColorInfo)colorInfo).setColorGroup(partsSpecColorGroup);
                ((ColorInfo)colorInfo).setSyncColorGroup(true);
                entry.setValue((ColorInfo)colorInfo);
            }
        } else {
            CategoryColorInfo categoryColorInfo = this.categoryColorInfoMap.get(category);
            if (categoryColorInfo != null) {
                PartsColorInfo categoryPartsColorInfo = categoryColorInfo.getPartsColorInfo();
                for (Map.Entry entry : categoryPartsColorInfo.entrySet()) {
                    Layer layer = (Layer)entry.getKey();
                    ColorInfo colorInfo2 = (ColorInfo)entry.getValue();
                    if (colorInfo2 == null || !partsColorInfo.containsKey(layer)) continue;
                    colorInfo2 = colorInfo2.clone();
                    if (!categoryColorInfo.isApplyAll()) {
                        ColorGroup layerColorGroup = layer.getColorGroup();
                        if (layerColorGroup == null) {
                            layerColorGroup = ColorGroup.NA;
                        }
                        colorInfo2.setColorGroup(layerColorGroup);
                    }
                    partsColorInfo.put(layer, colorInfo2);
                }
            }
        }
        for (Map.Entry<Layer, ColorInfo> entry : partsColorInfo.entrySet()) {
            ColorConvertParameter param;
            colorInfo = entry.getValue();
            ColorGroup colorGroup = ((ColorInfo)colorInfo).getColorGroup();
            if (colorGroup == null || !colorGroup.isEnabled() || !((ColorInfo)colorInfo).isSyncColorGroup() || (param = this.getRecentColorGroup(colorGroup)) == null) continue;
            ((ColorInfo)colorInfo).setColorParameter(param);
        }
        return partsColorInfo;
    }

    public Map<PartsIdentifier, PartsColorInfo> getPartsColorInfoMap() {
        return this.partsColorInfoMap;
    }

    public static final class CategoryColorInfo {
        private final PartsColorInfo partsColorInfo;
        private final boolean applyAll;

        public CategoryColorInfo(PartsColorInfo partsColorInfo, boolean applyAll) {
            this.partsColorInfo = partsColorInfo;
            this.applyAll = applyAll;
        }

        public PartsColorInfo getPartsColorInfo() {
            return this.partsColorInfo;
        }

        public boolean isApplyAll() {
            return this.applyAll;
        }
    }
}

