<?php
const DB_NAME = 'mydb.db';

$pdo = new PDO('sqlite:' . DB_NAME);
// SQL実行時にもエラーの代わりに例外を投げるように設定
// (毎回if文を書く必要がなくなる)
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
$pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);

// テーブル作成
$pdo->exec("CREATE TABLE IF NOT EXISTS ZIP_ENTRIES(
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    fname VARCHAR,
    fsize INTEGER,
    title VARCHAR,
    author VARCHAR,
    delkey VARCHAR,
    license VARCHAR,
    comment VARCHAR,
    regdate TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    hostaddr VARCHAR
)");

$rows = [];
$mx = 1000;
for ($idx = 0; $idx < $mx; $idx++) {
    $rows[] = [
        'fname' => "<name>&<${idx}>",
        'fsize' => $idx * 100,
        'title' => "<title>&<${idx}>",
        'author' => "<author>&<${idx}>",
        'comment' => "<comment>&<${idx}>",
        'license' => 'xxxx'
    ];
}


$stm = $pdo->prepare("insert into ZIP_ENTRIES(fname, fsize, title, author, license, comment)
    values (:fname, :fsize, :title, :author, :license, :comment)");
foreach ($rows as $row) {
    $stm->execute($row);
}

$stm = null;
$pdo = null;
?>