<?php
////////////////////////////////////////
// 通報を受け付けレポートとして登録するCGI
////////////////////////////////////////
require_once __DIR__ . '/common.php';

if (!isset($_POST['selected_id']) || !isset($_POST['report']) || !isset($_POST['report_type'])) {
    $result = [
        'result' => 'error',
        'zipid' => '',
        'message' => 'Bad request'
    ];
    echo json_encode($result);
    exit;
}

// 対象ZIP
$zipid = $_POST['selected_id'];

// 通報内容
$report = $_POST['report'];

// 通報タイプ
$report_type = $_POST['report_type'];

// 通報者のリモートアドレス
$hostaddr = get_hostaddr();

try {
    $pdo = create_pdo();
    $stm = $pdo->prepare('insert or replace into REPORT_ENTRIES(zipid, remote_addr, report_type, comment)
        values(:zipid, :remote_addr, :report_type, :comment)');
    $stm->execute([
        'zipid' => $zipid,
        'remote_addr' => $hostaddr,
        'report_type' => $report_type,
        'comment' => $report
    ]);
    
    $result = [
        'result' => 'ok',
        'zipid' => $zipid,
        'report_type' => $report_type
    ];

} catch (Exception $ex) {
    $result = [
        'result' => 'error',
        'zipid' => $zipid,
        'message' => 'internal error' // $ex->getMessage()
    ];
}
echo json_encode($result);
?>