<?php
////////////////////////////////////
// すべてのタグ一覧(JSON)を取得するCGI
////////////////////////////////////
require_once __DIR__ . '/common.php';
require_once __DIR__ . '/calc_trip.php';

header("Content-type: application/json; charset=utf-8");

// DataGridのページャのページサイズとページ範囲、ソートカラム、順序等の情報を取得する
$page = intval(isset($_GET['page']) ? $_GET['page'] : 1);
$pageSize = intval(isset($_GET['rows']) ? $_GET['rows'] : 10);
$sortColumn = isset($_GET['sort']) ? $_GET['sort'] : 'tagname';
$sortOrder = isset($_GET['order']) ? ($_GET['order'] == 'asc' ? 'asc' : 'desc') : 'asc';

// パラメータの妥当性チェック
$valid_columns = [
    'id', 'tagname', 'maxcnt'
];
if (!in_array($sortColumn, $valid_columns)) {
    // 妥当なカラム名でなければサーバーエラーを返す
    header($_SERVER['SERVER_PROTOCOL'] . ' 500 Internal Server Error', true, 500);
    exit;
}

$pdo = create_pdo();

// 件数取得
$countFetch = $pdo->prepare('select count(*) from tag_entries');
$countFetch->execute();
$totalCount = $countFetch->fetchColumn();
$countFetch = null;

// ページャの要求範囲でのデータ取得(ソートも指定)
$startPos = ($page - 1) * $pageSize;
$fetch = $pdo->prepare("select id, tagname, maxcnt from tag_entries a left outer join (
    select tagid, max(cnt) maxcnt from (
    select tagid, count(*) cnt from tag_parts_rel group by tagid
    union all
    select tagid, count(*) cnt from tag_zip_rel
    inner join parts_entries on tag_zip_rel.zipid = parts_entries.zipid group by tagid)
    group by tagid) b on a.id = b.tagid
    order by ${sortColumn} ${sortOrder} limit :pageSize offset :startPos");
$fetch->execute([
    //'sortArg' => ($sortColumn . ' ' . $sortOrder),
    'pageSize' => $pageSize,
    'startPos' => $startPos
]);
$rows = $fetch->fetchAll();
if ($rows === false) {
    // 読み取りに失敗した場合はサーバーエラーとする
    header($_SERVER['SERVER_PROTOCOL'] . ' 500 Internal Server Error', true, 500);
    exit;
}

$fetch = null;
$pdo = null;

$result = [
    'total' => $totalCount,
    'rows' => $rows
];
echo json_encode($result);
?>