<?php
////////////////////////////////////////////////////////
// 指定したzipファイルのコメント・タグ・パーツ一覧を取得するCGI
////////////////////////////////////////////////////////
require_once __DIR__ . '/common.php';
require_once __DIR__ . '/calc_trip.php';

header("Content-type: application/json; charset=utf-8");

// 対象zipid
$zipid = intval(isset($_GET['zipid']) ? $_GET['zipid'] : 1);
// 取得するタイプ comment, tag, parts、組み合わせ可
$contentsTypes = isset($_GET['contentsTypes']) ? $_GET['contentsTypes'] : [];

header('x-contentTypes: ' . urlencode(var_export($contentsTypes, true)));

$pdo = create_pdo();

$stm = $pdo->prepare('select comment from zip_entries where id = ?');
$stm->execute([$zipid]);
$comment = $stm->fetchColumn();
if ($comment == false) {
    $comment = '';
}

$tags = [];
if (in_array('tag', $contentsTypes, true)) {
    $stm = $pdo->prepare('select distinct tagname, kind from (
        select tagname, 0 kind from tag_entries inner join tag_zip_rel on tag_entries.id = tag_zip_rel.tagid where zipid = :zipid
        union all
        select tagname, 1 kind from tag_entries inner join tag_parts_rel on tag_entries.id = tag_parts_rel.tagid
         inner join parts_entries on tag_parts_rel.partsid = parts_entries.id where zipid = :zipid
        ) order by kind, tagname');
    $stm->execute([
        'zipid' => $zipid
    ]);
    $rows = $stm->fetchAll();
    if ($rows !== false) {
        foreach ($rows as $row) {
            $tags[] = $row['tagname'];
        }
    }
}

$parts = [];
if (in_array('parts', $contentsTypes, true)) {
    $stm = $pdo->prepare('select partsname from parts_entries where zipid = ? order by partsname');
    $stm->execute([$zipid]);
    $rows = $stm->fetchAll();
    if ($rows !== false) {
        foreach ($rows as $row) {
            $parts[] = $row['partsname'];
        }
    }
}

$result = [
    'comment' => $comment,
    'tags' => $tags,
    'partsnames' => $parts
];

echo json_encode($result);
?>
