<?php
////////////////////////////////////////
// OAuth2によるログイン処理のためのCGI
////////////////////////////////////////
//ini_set('display_errors', 1);
require_once __DIR__ . '/../cgi-bin/common.php';
require_once __DIR__ . '/../cgi-bin/secret.php';

if (empty($_GET['state'])) {
    // 承諾の可否にかかわらず、stateは返されるはず。そうでなければ何らかの内部エラー
    header($_SERVER['SERVER_PROTOCOL'] . ' 500 Internal Server Error', true, 500);
    exit;
}
$state = $_GET['state'];
if ($state == 'localhost' || $state == 'localhost.charactermanaj.osdn.jp') {
    // 開発用ローカルの識別子
    $redirect_url = "http://${state}:8888/htdocs/upload.html";
} else if ($state == 'native') {
    // ネイティブの識別子
    $redirect_url = "";
} else {
    // そうでなければ公開用と見なす
    $redirect_url = 'http://charactermanaj.osdn.jp/upload.html';
}

if (empty($_GET['code'])) {
    // 承諾しなかった場合はcode等は設定されずにリダイレクトされる
    if (empty($redirect_url)) {
        header($_SERVER['SERVER_PROTOCOL'] . ' 401 ACCESS DENIED', true, 401);
    } else {
        header('location: ' . $redirect_url);
    }
    exit;
}
$code = $_GET['code'];

$curl = curl_init();
if ($curl === false) {
    header($_SERVER['SERVER_PROTOCOL'] . ' 500 Internal Server Error', true, 500);
    exit;
}

curl_setopt($curl, CURLOPT_URL, 'https://osdn.net/api/v0/token');
curl_setopt($curl, CURLOPT_HTTPHEADER, [
    'User-Agent: Wget/1.16 (linux-gnu)'
]);

// リダイレクトの有効化、回数制限、リファラの自動設定
curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($curl, CURLOPT_MAXREDIRS, 10);
curl_setopt($curl, CURLOPT_AUTOREFERER, true);

// SSL対応
curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);

$params = [
    'client_id' => OSDN_CMJ_CLIENTKEY,
    'client_secret' => OSDN_CMJ_SECRETKEY,
    'grant_type' => 'authorization_code',
    'code' => $code
];
curl_setopt($curl, CURLOPT_POST, true);
curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($params));

curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
$res = curl_exec($curl);
if ($res === false ) {
    header("Content-type: text/plain; charset=utf-8");
    echo '{"error":"connection error","error_description":"connection error"}';
    exit;
}

$result = json_decode($res, true);
if (isset($result['error'])) {
    header("Content-type: text/plain; charset=utf-8");
    echo $res;
    exit;
}

$access_token = $result['access_token'];

//curl -X GET --header "Accept: application/json" --header "Authorization: Bearer baa4d1727b231209547058555c4c662ac7dca68f" "https://osdn.net/api/v0/ping"

curl_setopt($curl, CURLOPT_URL, 'https://osdn.net/api/v0/ping');
curl_setopt($curl, CURLOPT_POST, false);

curl_setopt($curl, CURLOPT_HTTPHEADER, [
    'User-Agent: Wget/1.16 (linux-gnu)',
    'Authorization: Bearer ' . $access_token
]);

curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
$res = curl_exec($curl);
if ($res === false ) {
    header("Content-type: text/plain; charset=utf-8");
    echo '{"error":"connection error","error_description":"connection error"}';
    exit;
}

$result = json_decode($res, true);
if (isset($result['error'])) {
    header("Content-type: text/plain; charset=utf-8");
    echo $res;
    exit;
}

$login_id = $result['login_id'];
$login_name = $result['login_name'];

if ($state == 'json') {
    header("Content-type: text/plain; charset=utf-8");
    echo $res;
    exit;    
}

$credential = [
    'id' => $login_id,
    'expired' => time() + (24 * 60 * 60)
];
$credential_json = json_encode($credential);
$credential_json_b64 = base64url_encode($credential_json);
$credential_hmac_b64 = base64url_encode(hash_hmac('sha256', $credential_json, CMD_UPLOADER_SID_KEY, true));
$sid = $credential_json_b64 . '.' . $credential_hmac_b64;

setcookie('cmj-uploader-sid', $sid, 0, '/', '.charactermanaj.osdn.jp');

append_log("login: ${login_id} ${login_name} ${sid}");

$pdo = create_pdo();

// アップロード・削除制限レコードをクリアする
$stm = $pdo->prepare('delete from REMOTE_ENTRIES where REMOTE_ADDR = ?');
$stm->execute([
    get_hostaddr()
]);

?><!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <title>login</title>
    <?php if (!empty($redirect_url)): ?>
        <meta http-equiv="refresh" content="0;URL='<?= $redirect_url ?>'"/>
    <?php endif; ?>
</head>
<body>
    <?php if (!empty($redirect_url)): ?>
        <a href="<?= $redirect_url ?>">logged in</a>
    <?php else: ?>
        <p>LOGIN CODE: <?= $sid ?>
    <?php endif; ?>
</body>
</html>