/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.ui.CategoriesTableRow;
import charactermanaj.ui.ColorGroupsTableRow;
import charactermanaj.ui.LayersTableRow;
import charactermanaj.ui.model.AbstractTableModelWithComboBoxModel;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.util.Collections;
import java.util.Comparator;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LayersTableModel
extends AbstractTableModelWithComboBoxModel<LayersTableRow> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(LayersTableModel.class.getName());
    private static final String[] layerColumnNames;
    private static final int[] layersColumnWidths;
    private int serialCounter = 1;

    public void adjustColumnModel(TableColumnModel columnModel) {
        for (int idx = 0; idx < layersColumnWidths.length; ++idx) {
            columnModel.getColumn(idx).setPreferredWidth(layersColumnWidths[idx]);
        }
    }

    public void addNewLayer() {
        LayersTableRow layer = new LayersTableRow();
        String layerId = "lay" + UUID.randomUUID().toString();
        String layerName = "Layer" + this.serialCounter++;
        layer.setLayerId(layerId);
        layer.setLayerName(layerName);
        this.addRow(layer);
    }

    @Override
    public int getColumnCount() {
        return layerColumnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return layerColumnNames[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        LayersTableRow layer = (LayersTableRow)this.elements.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return layer.getLayerName();
            }
            case 1: {
                return layer.getPartsCategory();
            }
            case 2: {
                return layer.getColorGroup();
            }
            case 3: {
                return layer.getOrder();
            }
            case 4: {
                return layer.getDir();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        LayersTableRow layer = (LayersTableRow)this.elements.get(rowIndex);
        try {
            switch (columnIndex) {
                case 0: {
                    layer.setLayerName((String)aValue);
                    break;
                }
                case 1: {
                    layer.setPartsCategory((CategoriesTableRow)aValue);
                    break;
                }
                case 2: {
                    layer.setColorGroup((ColorGroupsTableRow)aValue);
                    break;
                }
                case 3: {
                    layer.setOrder(((Number)aValue).intValue());
                    break;
                }
                case 4: {
                    layer.setDir((String)aValue);
                    break;
                }
                default: {
                    return;
                }
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "value set failed. (" + rowIndex + ", " + columnIndex + "): " + aValue, ex);
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return CategoriesTableRow.class;
            }
            case 2: {
                return ColorGroupsTableRow.class;
            }
            case 3: {
                return Integer.class;
            }
            case 4: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.isEditable();
    }

    public void sort() {
        Collections.sort(this.elements, new Comparator<LayersTableRow>(){

            @Override
            public int compare(LayersTableRow o1, LayersTableRow o2) {
                CategoriesTableRow p2;
                CategoriesTableRow p1 = o1.getPartsCategory();
                int ret = p1 == (p2 = o2.getPartsCategory()) ? 0 : (p1 != null && p2 != null ? p1.compareTo(p2) : (p1 == null ? -1 : 1));
                if (ret == 0) {
                    ret = o1.getOrder() - o2.getOrder();
                }
                if (ret == 0) {
                    ret = o1.getLayerId().compareTo(o2.getLayerId());
                }
                return ret;
            }
        });
        this.fireTableDataChanged();
    }

    protected boolean isUsed(ColorGroupsTableRow colorGroup) {
        if (colorGroup != null) {
            for (LayersTableRow layer : this.elements) {
                if (!ColorGroupsTableRow.equals(layer.getColorGroup(), colorGroup)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isUsed(CategoriesTableRow partsCategory) {
        if (partsCategory != null) {
            for (LayersTableRow layer : this.elements) {
                if (!CategoriesTableRow.equals(layer.getPartsCategory(), partsCategory)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("languages/profileditdialog");
        layerColumnNames = new String[]{strings.getProperty("layers.column.layername"), strings.getProperty("layers.column.category"), strings.getProperty("layers.column.colorgroup"), strings.getProperty("layers.column.order"), strings.getProperty("layers.column.directory")};
        layersColumnWidths = new int[]{Integer.parseInt(strings.getProperty("layers.column.layername.width")), Integer.parseInt(strings.getProperty("layers.column.category.width")), Integer.parseInt(strings.getProperty("layers.column.colorgroup.width")), Integer.parseInt(strings.getProperty("layers.column.order.width")), Integer.parseInt(strings.getProperty("layers.column.directory.width"))};
    }
}

