/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.filters;

import charactermanaj.graphics.filters.AbstractFilter;
import charactermanaj.graphics.filters.GammaTableFactory;
import java.awt.Color;

public class ColorConvertFilter
extends AbstractFilter {
    private final ColorReplace colorReplace;
    private final float[] hsbOffsets;
    private final float grayLevel;
    private final int[][] gammaTbl;

    public ColorConvertFilter(ColorReplace colorReplace, float[] hsbOffsets, float grayLevel, GammaTableFactory gammaTableFactory) {
        if (gammaTableFactory == null) {
            gammaTableFactory = new GammaTableFactory(1.0f);
        }
        if (hsbOffsets != null && ((float[])hsbOffsets).length < 3) {
            throw new IllegalArgumentException("hsbOffset too short.");
        }
        if (hsbOffsets != null) {
            hsbOffsets = hsbOffsets[0] == 0.0f && hsbOffsets[1] == 0.0f && hsbOffsets[2] == 0.0f ? null : (float[])hsbOffsets.clone();
        }
        if (grayLevel < 0.0f) {
            grayLevel = 0.0f;
        } else if (grayLevel > 1.0f) {
            grayLevel = 1.0f;
        }
        this.grayLevel = grayLevel;
        this.gammaTbl = gammaTableFactory.createGammaTable();
        this.hsbOffsets = hsbOffsets;
        this.colorReplace = colorReplace;
    }

    protected void filter(int[] pixcels) {
        float grayLevel = this.grayLevel;
        float negGrayLevel = 1.0f - grayLevel;
        int[] precalc = new int[256];
        int[] negPrecalc = new int[256];
        for (int i = 0; i < 256; ++i) {
            precalc[i] = (int)((float)i * grayLevel) & 0xFF;
            negPrecalc[i] = (int)((float)i * negGrayLevel) & 0xFF;
        }
        ColorReplace colorReplace = this.colorReplace;
        int[] rgbvals = new int[3];
        float[] hsbOffsets = this.hsbOffsets;
        float[] hsbvals = new float[3];
        int[][] gammaTbl = this.gammaTbl;
        for (int argb : pixcels) {
            int a = gammaTbl[0][argb >> 24 & 0xFF];
            int r = gammaTbl[1][argb >> 16 & 0xFF];
            int g = gammaTbl[2][argb >> 8 & 0xFF];
            int b = gammaTbl[3][argb & 0xFF];
            if (colorReplace != null) {
                rgbvals[0] = r;
                rgbvals[1] = g;
                rgbvals[2] = b;
                colorReplace.convert(rgbvals);
                r = rgbvals[0];
                g = rgbvals[1];
                b = rgbvals[2];
            }
            int br = 77 * r + 150 * g + 29 * b >> 8 & 0xFF;
            r = precalc[r] + negPrecalc[br] & 0xFF;
            g = precalc[g] + negPrecalc[br] & 0xFF;
            b = precalc[b] + negPrecalc[br] & 0xFF;
            if (hsbOffsets != null) {
                int l;
                Color.RGBtoHSB(r, g, b, hsbvals);
                for (l = 0; l < 3; ++l) {
                    int n = l;
                    hsbvals[n] = hsbvals[n] + hsbOffsets[l];
                }
                for (l = 1; l < 3; ++l) {
                    if (hsbvals[l] < 0.0f) {
                        hsbvals[l] = 0.0f;
                        continue;
                    }
                    if (!(hsbvals[l] > 1.0f)) continue;
                    hsbvals[l] = 1.0f;
                }
                int rgb = Color.HSBtoRGB(hsbvals[0], hsbvals[1], hsbvals[2]);
                argb = a << 24 | rgb & 0xFFFFFF;
            } else {
                argb = a << 24 | r << 16 | g << 8 | b;
            }
            pixcels[i] = argb;
        }
    }

    public static interface ColorReplace {
        public void convert(int[] var1);
    }
}

