/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.ui.AppConfigRowModel;
import charactermanaj.ui.model.AbstractTableModelWithComboBoxModel;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AppConfigTableModel
extends AbstractTableModelWithComboBoxModel<AppConfigRowModel> {
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMN_NAMES;
    private static final int[] COLUMN_WIDTHS;
    private Properties target = new Properties();
    private Properties original;

    AppConfigTableModel() {
    }

    public void initModel(Properties original) {
        this.clear();
        this.target.clear();
        this.original = original;
        if (original != null) {
            this.target.putAll((Map<?, ?>)original);
            Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/appconfigdialog");
            for (Object key : this.target.keySet()) {
                String displayName = strings.getProperty((String)key);
                if (displayName == null || displayName.length() == 0) {
                    displayName = (String)key;
                }
                AppConfigRowModel rowModel = new AppConfigRowModel(this.target, (String)key, displayName);
                this.addRow(rowModel);
            }
        }
        this.sort();
    }

    public void sort() {
        Collections.sort(this.elements);
        this.fireTableDataChanged();
    }

    public void setRejectNames(Set<String> rejectNames) {
        for (AppConfigRowModel rowModel : this.elements) {
            String key = rowModel.getKey();
            boolean rejected = rejectNames != null && rejectNames.contains(key);
            rowModel.setRejected(rejected);
        }
        this.fireTableDataChanged();
    }

    public boolean isModified() {
        if (this.original == null) {
            return true;
        }
        return !this.original.equals(this.target);
    }

    public Properties getProperties() {
        return this.target;
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        AppConfigRowModel rowModel = (AppConfigRowModel)this.getRow(rowIndex);
        switch (columnIndex) {
            case 0: {
                return rowModel.getDisplayName();
            }
            case 1: {
                return rowModel.getValue();
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        AppConfigRowModel rowModel = (AppConfigRowModel)this.getRow(rowIndex);
        if (columnIndex == 1) {
            rowModel.setValue((String)aValue);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    public void adjustColumnModel(TableColumnModel columnModel) {
        int mx = columnModel.getColumnCount();
        for (int idx = 0; idx < mx; ++idx) {
            columnModel.getColumn(idx).setWidth(COLUMN_WIDTHS[idx]);
        }
    }

    static {
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/appconfigdialog");
        COLUMN_NAMES = new String[]{strings.getProperty("column.key"), strings.getProperty("column.value")};
        COLUMN_WIDTHS = new int[]{Integer.parseInt(strings.getProperty("column.key.width")), Integer.parseInt(strings.getProperty("column.value.width"))};
    }
}

