/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.CharacterData;
import charactermanaj.ui.AbstractImportPanel;
import charactermanaj.ui.ExportInformationResolver;
import charactermanaj.ui.SamplePicturePanel;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class ExportInformationPanel
extends AbstractImportPanel
implements ExportInformationResolver {
    private static final long serialVersionUID = 1L;
    private BufferedImage samplePicture;
    private SamplePicturePanel sampleImagePanel;
    private JTextField txtAuthor;
    private JTextArea txtDescription;
    private JCheckBox chkPartsImages;
    private JCheckBox chkPresets;
    private JCheckBox chkSampleImage;

    protected ExportInformationPanel(CharacterData characterData, BufferedImage samplePicture) {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        this.setName("basicPanel");
        this.samplePicture = samplePicture;
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/exportwizdialog");
        GridBagLayout basicPanelLayout = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(basicPanelLayout);
        JPanel contentsSpecPanel = new JPanel();
        contentsSpecPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(strings.getProperty("basic.contentsSpec"))));
        BoxLayout contentsSpecPanelLayout = new BoxLayout(contentsSpecPanel, 3);
        contentsSpecPanel.setLayout(contentsSpecPanelLayout);
        JCheckBox chkCharacterDef = new JCheckBox(strings.getProperty("characterdef"));
        this.chkPartsImages = new JCheckBox(strings.getProperty("basic.chk.partsImages"));
        this.chkPresets = new JCheckBox(strings.getProperty("basic.chk.presets"));
        this.chkSampleImage = new JCheckBox(strings.getProperty("basic.chk.samplePicture"));
        chkCharacterDef.setEnabled(false);
        chkCharacterDef.setSelected(true);
        contentsSpecPanel.add(chkCharacterDef);
        contentsSpecPanel.add(this.chkPartsImages);
        contentsSpecPanel.add(this.chkPresets);
        contentsSpecPanel.add(this.chkSampleImage);
        JPanel commentPanel = new JPanel();
        Dimension archiveInfoPanelMinSize = new Dimension(300, 200);
        commentPanel.setMinimumSize(archiveInfoPanelMinSize);
        commentPanel.setPreferredSize(archiveInfoPanelMinSize);
        commentPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(strings.getProperty("basic.comment"))));
        GridBagLayout commentPanelLayout = new GridBagLayout();
        commentPanel.setLayout(commentPanelLayout);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.anchor = 17;
        gbc.fill = 1;
        commentPanel.add((Component)new JLabel(strings.getProperty("author"), 4), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.txtAuthor = new JTextField();
        commentPanel.add((Component)this.txtAuthor, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        commentPanel.add((Component)new JLabel(strings.getProperty("description"), 4), gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 2;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        this.txtDescription = new JTextArea();
        this.txtDescription.setFont(this.getFont());
        commentPanel.add((Component)new JScrollPane(this.txtDescription), gbc);
        this.sampleImagePanel = new SamplePicturePanel(samplePicture);
        this.sampleImagePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(strings.getProperty("basic.sampleImage"))));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        this.add((Component)contentsSpecPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        this.add((Component)commentPanel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        this.add((Component)this.sampleImagePanel, gbc);
        this.loadBasicInfo(characterData);
        ActionListener modListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExportInformationPanel.this.updateSamplePicture();
                ExportInformationPanel.this.fireChangeEvent();
            }
        };
        this.chkPartsImages.addActionListener(modListener);
        this.chkPresets.addActionListener(modListener);
        this.chkSampleImage.addActionListener(modListener);
    }

    protected void updateSamplePicture() {
        this.sampleImagePanel.setVisiblePicture(this.chkSampleImage.isSelected());
    }

    protected void loadBasicInfo(CharacterData characterData) {
        if (this.samplePicture == null) {
            this.chkSampleImage.setEnabled(false);
            this.chkSampleImage.setSelected(false);
            this.sampleImagePanel.setVisiblePicture(false);
        } else {
            this.chkSampleImage.setSelected(true);
            this.sampleImagePanel.setVisiblePicture(true);
        }
        this.chkPartsImages.setSelected(true);
        this.chkPresets.setSelected(true);
        String author = characterData.getAuthor();
        String description = characterData.getDescription();
        this.txtAuthor.setText(author == null ? "" : author);
        this.txtDescription.setText(description == null ? "" : description);
    }

    public BufferedImage getSamplePicture() {
        return this.samplePicture;
    }

    public boolean isExportSamplePicture() {
        return this.chkSampleImage.isSelected();
    }

    public boolean isExportPartsImages() {
        return this.chkPartsImages.isSelected();
    }

    public boolean isExportPresets() {
        return this.chkPresets.isSelected();
    }

    public String getAuthor() {
        return this.txtAuthor.getText();
    }

    public String getDescription() {
        return this.txtDescription.getText();
    }
}

