/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.util;

import charactermanaj.model.CharacterData;
import charactermanaj.model.io.CharacterDataPersistent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;

public class MakeEmbeddedResource {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String fileName = "resources/schema/character.xml.ser";
        if (args.length >= 1) {
            fileName = args[0];
        }
        File file = new File(fileName);
        Locale[] locales = new Locale[]{Locale.ENGLISH, Locale.JAPANESE};
        HashMap<String, CharacterData> characterDataMap = new HashMap<String, CharacterData>();
        for (Locale locale : locales) {
            String lang = locale.getLanguage();
            if (characterDataMap.containsKey(lang)) continue;
            CharacterData cd = MakeEmbeddedResource.loadDefaultCharacterData(locale);
            characterDataMap.put(lang, cd);
        }
        FileOutputStream fos = new FileOutputStream(file);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            try {
                oos.writeObject(characterDataMap);
            }
            finally {
                oos.close();
            }
        }
        finally {
            fos.close();
        }
        System.out.println("make embedded resource : succeeded. file=" + file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static CharacterData loadDefaultCharacterData(Locale locale) throws Exception {
        CharacterData cd;
        URL defaultCharacter = MakeEmbeddedResource.getEmbeddedResourceURL("/schema/character.xml");
        InputStream is = defaultCharacter.openStream();
        try {
            CharacterDataPersistent.DocInfo docInfo = new CharacterDataPersistent.DocInfo();
            docInfo.setFirstElementName("character");
            docInfo.setNamespace("http://charactermanaj.sourceforge.jp/schema/charactermanaj");
            docInfo.setVersion("1.0");
            CharacterDataPersistent persist = CharacterDataPersistent.getInstance();
            cd = persist.loadCharacterDataFromXML(is, null, docInfo, locale);
        }
        finally {
            is.close();
        }
        return cd;
    }

    protected static URL getEmbeddedResourceURL(String schemaName) {
        return CharacterDataPersistent.class.getResource(schemaName);
    }
}

