/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui.model;

import charactermanaj.util.LocalizedMessageAware;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredefinedWallpaper
implements Comparable<PredefinedWallpaper>,
LocalizedMessageAware {
    private static final String PREDEFINED_WALLPAPER_RESOURCE = "images/wallpaper";
    private final String key;
    private final String msgid;
    private final String resource;

    protected PredefinedWallpaper(String key, String msgid, String resource) {
        this.key = key;
        this.msgid = msgid;
        this.resource = resource;
    }

    @Override
    public String getLocalizedResourceId() {
        return "predefinedWallpaper." + this.msgid;
    }

    public String getKey() {
        return this.key;
    }

    public String getMsgid() {
        return this.msgid;
    }

    public String getResource() {
        return this.resource;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PredefinedWallpaper) {
            PredefinedWallpaper o = (PredefinedWallpaper)obj;
            return this.key.equals(o.key);
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    @Override
    public int compareTo(PredefinedWallpaper o) {
        return this.key.compareTo(o.key);
    }

    public String toString() {
        return this.msgid;
    }

    public static List<PredefinedWallpaper> getPredefinedWallpapers() {
        Properties predefinedWallpapers = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(PREDEFINED_WALLPAPER_RESOURCE);
        ArrayList<PredefinedWallpaper> results = new ArrayList<PredefinedWallpaper>();
        for (Map.Entry<Object, Object> entry : predefinedWallpapers.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            int pt = value.indexOf(59);
            String msgid = pt >= 0 ? value.substring(pt + 1) : value;
            PredefinedWallpaper predefinedWallpaper = new PredefinedWallpaper(key, msgid, "images/" + key);
            results.add(predefinedWallpaper);
        }
        Collections.sort(results);
        return results;
    }
}

