/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.util;

import charactermanaj.model.util.StartupSupportForDocBasedData;
import charactermanaj.util.UserDataFactory;
import java.io.File;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

class PurgeUnusedCache
extends StartupSupportForDocBasedData {
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    PurgeUnusedCache() {
    }

    public void doStartup() {
        String[] suffixes;
        Map<String, File> docBaseSignatures = this.getDocBaseMap(StartupSupportForDocBasedData.DocBaseSignatureStoratage.NEW_FORMAT);
        UserDataFactory userDataFactory = UserDataFactory.getInstance();
        File cacheDir = userDataFactory.getSpecialDataDir("*.ser");
        for (String suffix : suffixes = new String[]{"-character.xml-cache.ser", "-workingset.ser", "-favorites.ser"}) {
            Map<String, File> caches = this.getUUIDMangledNamedMap(cacheDir, suffix);
            for (Map.Entry<String, File> cacheEntry : caches.entrySet()) {
                String mangledUUID = cacheEntry.getKey();
                File cacheFile = cacheEntry.getValue();
                try {
                    if (docBaseSignatures.containsKey(mangledUUID)) continue;
                    boolean result = cacheFile.delete();
                    this.logger.log(Level.INFO, "purge unused cache: " + cacheFile + "/succeeded=" + result);
                }
                catch (Exception ex) {
                    this.logger.log(Level.WARNING, "remove file failed. " + cacheFile, ex);
                }
            }
        }
    }
}

