/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.Main;
import charactermanaj.model.AppConfig;
import charactermanaj.ui.AppConfigRowModel;
import charactermanaj.ui.AppConfigTableModel;
import charactermanaj.util.ErrorMessageHelper;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellRenderer;

public class AppConfigDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private AppConfigTableModel appConfigTableModel;
    private JTable appConfigTable;

    public AppConfigDialog(JFrame parent) {
        super((Frame)parent, true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AppConfigDialog.this.onClose();
            }
        });
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/appconfigdialog");
        this.setTitle(strings.getProperty("title"));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel btnPanel = new JPanel();
        btnPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 45));
        GridBagLayout btnPanelLayout = new GridBagLayout();
        btnPanel.setLayout(btnPanelLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        AbstractAction actApply = new AbstractAction(strings.getProperty("btn.apply")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                AppConfigDialog.this.onUpdate();
            }
        };
        AbstractAction actCancel = new AbstractAction(strings.getProperty("btn.cancel")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                AppConfigDialog.this.onClose();
            }
        };
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        btnPanel.add(Box.createHorizontalGlue(), gbc);
        gbc.gridx = Main.isMacOSX() ? 2 : 1;
        gbc.weightx = 0.0;
        JButton btnApply = new JButton(actApply);
        btnPanel.add((Component)btnApply, gbc);
        gbc.gridx = Main.isMacOSX() ? 1 : 2;
        gbc.weightx = 0.0;
        JButton btnCancel = new JButton(actCancel);
        btnPanel.add((Component)btnCancel, gbc);
        this.add((Component)btnPanel, "South");
        this.setSize(350, 400);
        this.setLocationRelativeTo(parent);
        JLabel lblCaution = new JLabel(strings.getProperty("caution"), 0);
        lblCaution.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        lblCaution.setForeground(Color.red);
        contentPane.add((Component)lblCaution, "North");
        this.appConfigTableModel = new AppConfigTableModel();
        Properties original = AppConfig.getInstance().getProperties();
        this.appConfigTableModel.initModel(original);
        AppConfig appConfig = AppConfig.getInstance();
        final Color invalidBgColor = appConfig.getInvalidBgColor();
        this.appConfigTable = new JTable(this.appConfigTableModel){
            private static final long serialVersionUID = 1L;

            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component comp = super.prepareRenderer(renderer, row, column);
                AppConfigRowModel rowModel = (AppConfigRowModel)AppConfigDialog.this.appConfigTableModel.getRow(row);
                if (rowModel.isRejected()) {
                    comp.setBackground(invalidBgColor);
                } else if (this.isCellSelected(row, column)) {
                    comp.setBackground(this.getSelectionBackground());
                } else {
                    comp.setBackground(this.getBackground());
                }
                return comp;
            }

            public String getToolTipText(MouseEvent event) {
                int row = this.rowAtPoint(event.getPoint());
                int col = this.columnAtPoint(event.getPoint());
                if (col == 0) {
                    AppConfigRowModel rowModel = (AppConfigRowModel)AppConfigDialog.this.appConfigTableModel.getRow(row);
                    return rowModel.getDisplayName();
                }
                return super.getToolTipText(event);
            }
        };
        this.appConfigTable.setAutoResizeMode(3);
        this.appConfigTable.setShowGrid(true);
        this.appConfigTable.setGridColor(AppConfig.getInstance().getGridColor());
        this.appConfigTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.appConfigTableModel.adjustColumnModel(this.appConfigTable.getColumnModel());
        JScrollPane appConfigTableSP = new JScrollPane(this.appConfigTable);
        appConfigTableSP.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3), BorderFactory.createTitledBorder(strings.getProperty("table.caption"))));
        appConfigTableSP.setVerticalScrollBarPolicy(22);
        contentPane.add((Component)appConfigTableSP, "Center");
        JRootPane rootPane = this.getRootPane();
        InputMap im = rootPane.getInputMap(2);
        ActionMap am = rootPane.getActionMap();
        im.put(KeyStroke.getKeyStroke(27, 0), "closeAppConfigDialog");
        am.put("closeAppConfigDialog", actCancel);
    }

    protected void onClose() {
        Properties strings;
        if (this.appConfigTableModel.isModified() && JOptionPane.showConfirmDialog(this, (strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/appconfigdialog")).getProperty("confirm.close"), strings.getProperty("confirm.close.caption"), 0, 3) != 0) {
            return;
        }
        this.dispose();
    }

    protected void onUpdate() {
        if (this.appConfigTable.isEditing()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/appconfigdialog");
        Properties props = this.appConfigTableModel.getProperties();
        Set<String> rejectNames = AppConfig.checkProperties(props);
        if (!rejectNames.isEmpty()) {
            this.appConfigTableModel.setRejectNames(rejectNames);
            JOptionPane.showMessageDialog(this, strings.getProperty("error.message"), strings.getProperty("error.caption"), 0);
            return;
        }
        AppConfig appConfig = AppConfig.getInstance();
        appConfig.update(props);
        try {
            appConfig.saveConfig();
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
        String message = strings.getProperty("caution");
        JOptionPane.showMessageDialog(this, message);
        this.dispose();
    }
}

