/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.Main;
import charactermanaj.clipboardSupport.ClipboardUtil;
import charactermanaj.graphics.io.FileImageResource;
import charactermanaj.graphics.io.ImageCachedLoader;
import charactermanaj.graphics.io.LoadedImage;
import charactermanaj.model.AppConfig;
import charactermanaj.model.CharacterData;
import charactermanaj.model.io.CharacterDataPersistent;
import charactermanaj.ui.ExportWizardDialog;
import charactermanaj.ui.ImportWizardDialog;
import charactermanaj.ui.MainFrame;
import charactermanaj.ui.ProfileEditDialog;
import charactermanaj.ui.ProfileListManager;
import charactermanaj.ui.SamplePicturePanel;
import charactermanaj.util.DesktopUtilities;
import charactermanaj.util.ErrorMessageHelper;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import charactermanaj.util.UIHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.text.MessageFormat;
import java.util.List;
import java.util.Properties;
import java.util.TooManyListenersException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileSelectorDialog
extends JDialog {
    private static final long serialVersionUID = -6883202891172975022L;
    private static final Logger logger = Logger.getLogger(ProfileSelectorDialog.class.getName());
    protected static final String STRINGS_RESOURCE = "strings/profileselectordialog";
    private ImageCachedLoader imageLoader = new ImageCachedLoader();
    private boolean canWriteSamplePicture;
    private SamplePicturePanel sampleImgPanel;
    private JButton btnOK;
    private JButton btnProfileNew;
    private JButton btnProfileEdit;
    private JButton btnProfileRemove;
    private JButton btnProfileBrowse;
    private JButton btnProfileImport;
    private JButton btnProfileExport;
    private JList characterList;
    private DefaultListModel characterListModel;
    private JTextArea descriptionArea;
    private CharacterData selectedCharacterData;

    public ProfileSelectorDialog(JFrame parent, List<CharacterData> characterDatas) {
        super((Frame)parent, true);
        if (characterDatas == null) {
            throw new IllegalArgumentException();
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ProfileSelectorDialog.this.onClosing();
            }
        });
        final Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        this.setTitle(strings.getProperty("title"));
        JPanel centerPanel = new JPanel();
        GridLayout gridLayout = new GridLayout(2, 1);
        centerPanel.setLayout(gridLayout);
        JPanel pnlProfiles = new JPanel(new BorderLayout());
        this.characterListModel = new DefaultListModel();
        for (CharacterData characterData : characterDatas) {
            this.characterListModel.addElement(characterData);
        }
        this.characterList = new JList(this.characterListModel);
        this.characterList.setSelectionMode(0);
        this.characterList.setCellRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                CharacterData characterData = (CharacterData)value;
                StringBuilder displayNameBuf = new StringBuilder();
                displayNameBuf.append(characterData.getName());
                if (ProfileListManager.isUsingCharacterData(characterData)) {
                    displayNameBuf.append(strings.getProperty("profile.opend"));
                }
                if (!characterData.canWrite()) {
                    displayNameBuf.append(strings.getProperty("profile.noteditable"));
                }
                return super.getListCellRendererComponent((JList<?>)list, displayNameBuf.toString(), index, isSelected, cellHasFocus);
            }
        });
        this.characterList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ProfileSelectorDialog.this.updateUIState();
            }
        });
        this.characterList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    ProfileSelectorDialog.this.onOK();
                }
            }
        });
        pnlProfiles.add((Component)this.characterList, "Center");
        JPanel pnlProfileEditButtons = new JPanel();
        pnlProfileEditButtons.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        GridBagLayout pnlProfileEditButtonsLayout = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        pnlProfileEditButtons.setLayout(pnlProfileEditButtonsLayout);
        this.btnProfileNew = new JButton(new AbstractAction(strings.getProperty("profile.new")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                boolean makeDefault = (e.getModifiers() & 1) != 0;
                ProfileSelectorDialog.this.onProfileNew(makeDefault);
            }
        });
        this.btnProfileEdit = new JButton(new AbstractAction(strings.getProperty("profile.edit")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ProfileSelectorDialog.this.onProfileEdit();
            }
        });
        this.btnProfileRemove = new JButton(new AbstractAction(strings.getProperty("profile.remove")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ProfileSelectorDialog.this.onProfileRemove();
            }
        });
        this.btnProfileBrowse = new JButton(new AbstractAction(strings.getProperty("profile.browse")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ProfileSelectorDialog.this.onProfileBrowse();
            }
        });
        this.btnProfileImport = new JButton(new AbstractAction(strings.getProperty("profile.import")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ProfileSelectorDialog.this.onProfileImport();
            }
        });
        this.btnProfileExport = new JButton(new AbstractAction(strings.getProperty("profile.export")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ProfileSelectorDialog.this.onProfileExport();
            }
        });
        this.btnProfileNew.setToolTipText(strings.getProperty("profile.new.tooltip"));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.insets = new Insets(0, 3, 0, 3);
        pnlProfileEditButtons.add((Component)this.btnProfileNew, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        pnlProfileEditButtons.add((Component)this.btnProfileEdit, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        pnlProfileEditButtons.add((Component)this.btnProfileRemove, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weighty = 1.0;
        pnlProfileEditButtons.add(Box.createGlue(), gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weighty = 0.0;
        pnlProfileEditButtons.add((Component)this.btnProfileBrowse, gbc);
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.weighty = 0.0;
        pnlProfileEditButtons.add((Component)this.btnProfileImport, gbc);
        gbc.gridx = 0;
        gbc.gridy = 6;
        pnlProfileEditButtons.add((Component)this.btnProfileExport, gbc);
        JPanel pnlProfilesGroup = new JPanel(new BorderLayout());
        pnlProfilesGroup.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createTitledBorder(strings.getProperty("profiles"))));
        pnlProfilesGroup.add((Component)pnlProfiles, "Center");
        pnlProfilesGroup.add((Component)pnlProfileEditButtons, "East");
        JPanel infoPanel = new JPanel(new GridLayout(1, 2));
        JPanel descriptionPanel = new JPanel(new BorderLayout());
        descriptionPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createTitledBorder(strings.getProperty("description"))));
        this.descriptionArea = new JTextArea();
        this.descriptionArea.setEditable(false);
        this.descriptionArea.setFont(this.getFont());
        descriptionPanel.add((Component)new JScrollPane(this.descriptionArea), "Center");
        this.sampleImgPanel = new SamplePicturePanel();
        this.sampleImgPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createTitledBorder(strings.getProperty("sample-image"))));
        DropTarget dt = new DropTarget();
        try {
            dt.addDropTargetListener(new DropTargetAdapter(){

                public void drop(DropTargetDropEvent dtde) {
                    ProfileSelectorDialog.this.onDrop(dtde);
                }
            });
        }
        catch (TooManyListenersException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        this.sampleImgPanel.setDropTarget(dt);
        final JPopupMenu popupMenu = new JPopupMenu();
        final JMenuItem popupMenuCut = popupMenu.add(new AbstractAction(strings.getProperty("samplepicture.cut")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ProfileSelectorDialog.this.onSamplePictureCut();
            }
        });
        final JMenuItem popupMenuPaste = popupMenu.add(new AbstractAction(strings.getProperty("samplepicture.paste")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ProfileSelectorDialog.this.onSamplePicturePaste();
            }
        });
        this.sampleImgPanel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                this.evaluatePopup(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.evaluatePopup(e);
            }

            private void evaluatePopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    popupMenuCut.setEnabled(ProfileSelectorDialog.this.sampleImgPanel.getSamplePictrue() != null && ProfileSelectorDialog.this.canWriteSamplePicture);
                    popupMenuPaste.setEnabled(ProfileSelectorDialog.this.canWriteSamplePicture && ClipboardUtil.hasImage());
                    popupMenu.show(ProfileSelectorDialog.this.sampleImgPanel, e.getX(), e.getY());
                }
            }
        });
        infoPanel.add(descriptionPanel);
        infoPanel.add(this.sampleImgPanel);
        centerPanel.add(pnlProfilesGroup);
        centerPanel.add(infoPanel);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)centerPanel, "Center");
        JPanel btnPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(btnPanel, 2);
        btnPanel.setLayout(boxLayout);
        btnPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 42));
        AbstractAction actOK = new AbstractAction(strings.getProperty("btn.select")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ProfileSelectorDialog.this.onOK();
            }
        };
        AbstractAction actCancel = new AbstractAction(strings.getProperty("btn.cancel")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ProfileSelectorDialog.this.onCancel();
            }
        };
        this.btnOK = new JButton(actOK);
        JButton btnCancel = new JButton(actCancel);
        if (Main.isMacOSX()) {
            btnPanel.add(btnCancel);
            btnPanel.add(this.btnOK);
        } else {
            btnPanel.add(this.btnOK);
            btnPanel.add(btnCancel);
        }
        JPanel btnPanel2 = new JPanel(new BorderLayout());
        btnPanel2.add((Component)btnPanel, "East");
        contentPane.add((Component)btnPanel2, "South");
        JRootPane rootPane = this.getRootPane();
        rootPane.setDefaultButton(this.btnOK);
        InputMap im = rootPane.getInputMap(2);
        ActionMap am = rootPane.getActionMap();
        im.put(KeyStroke.getKeyStroke(27, 0), "closeProfileSelectorDialog");
        am.put("closeProfileSelectorDialog", actCancel);
        this.pack();
        this.setSize(500, 500);
        this.setLocationRelativeTo(parent);
        this.characterList.requestFocus();
        this.updateUIState();
    }

    public CharacterData getSelectedCharacterData() {
        return this.selectedCharacterData;
    }

    protected void updateUIState() {
        CharacterData characterData = (CharacterData)this.characterList.getSelectedValue();
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        boolean selected = characterData != null;
        boolean enableEdit = characterData != null && characterData.canWrite();
        this.btnOK.setEnabled(selected);
        this.btnProfileNew.setEnabled(true);
        this.btnProfileEdit.setEnabled(selected);
        this.btnProfileRemove.setEnabled(selected && enableEdit);
        this.btnProfileImport.setEnabled(true);
        this.btnProfileExport.setEnabled(selected);
        this.btnProfileBrowse.setEnabled(selected);
        if (enableEdit) {
            this.btnProfileEdit.setText(strings.getProperty("profile.edit"));
        } else {
            this.btnProfileEdit.setText(strings.getProperty("profile.edit.readonly"));
        }
        boolean removable = characterData != null && characterData.isValid() && !ProfileListManager.isUsingCharacterData(characterData) && characterData.canWrite();
        this.btnProfileRemove.setEnabled(removable);
        boolean canWriteSamplePicture = false;
        BufferedImage sampleImage = null;
        if (characterData != null && characterData.isValid()) {
            Dimension imageSize;
            StringWriter sw = new StringWriter();
            PrintWriter descriptionBuf = new PrintWriter(sw);
            URI docBase = characterData.getDocBase();
            String author = characterData.getAuthor();
            String description = characterData.getDescription();
            if (docBase != null) {
                descriptionBuf.println("configuration: " + docBase);
            }
            if (author != null && author.length() > 0) {
                descriptionBuf.println("author: " + author);
            }
            if ((imageSize = characterData.getImageSize()) != null) {
                descriptionBuf.println("size: " + imageSize.width + "x" + imageSize.height);
            }
            if (description != null) {
                description = description.replace("\r\n", "\n");
                description = description.replace("\r", "\n");
                description = description.replace("\n", System.getProperty("line.separator"));
                descriptionBuf.println(description);
            }
            this.descriptionArea.setText(sw.toString());
            this.descriptionArea.setSelectionStart(0);
            this.descriptionArea.setSelectionEnd(0);
            try {
                CharacterDataPersistent persist = CharacterDataPersistent.getInstance();
                sampleImage = persist.loadSamplePicture(characterData, this.imageLoader);
                canWriteSamplePicture = persist.canSaveSamplePicture(characterData);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "sample picture loading failed. " + characterData, ex);
                sampleImage = null;
            }
        }
        this.canWriteSamplePicture = canWriteSamplePicture;
        String dropHere = strings.getProperty("dropHere");
        String noPicture = strings.getProperty("nopicture");
        this.sampleImgPanel.setSamplePicture(sampleImage);
        this.sampleImgPanel.setAlternateText(canWriteSamplePicture ? dropHere : noPicture);
    }

    protected void onSamplePictureCut() {
        CharacterData characterData = (CharacterData)this.characterList.getSelectedValue();
        BufferedImage img = this.sampleImgPanel.getSamplePictrue();
        Toolkit tk = Toolkit.getDefaultToolkit();
        if (characterData == null || !characterData.isValid() || !this.canWriteSamplePicture || img == null) {
            tk.beep();
            return;
        }
        try {
            Color bgColor = AppConfig.getInstance().getSampleImageBgColor();
            ClipboardUtil.setImage(img, bgColor);
            CharacterDataPersistent persist = CharacterDataPersistent.getInstance();
            persist.saveSamplePicture(characterData, null);
            this.sampleImgPanel.setSamplePicture(null);
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void onSamplePicturePaste() {
        CharacterData characterData = (CharacterData)this.characterList.getSelectedValue();
        Toolkit tk = Toolkit.getDefaultToolkit();
        if (characterData == null || !characterData.isValid() || !this.canWriteSamplePicture) {
            tk.beep();
            return;
        }
        try {
            BufferedImage img = ClipboardUtil.getImage();
            if (img != null) {
                CharacterDataPersistent persist = CharacterDataPersistent.getInstance();
                persist.saveSamplePicture(characterData, img);
                this.sampleImgPanel.setSamplePicture(img);
            } else {
                tk.beep();
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void onDrop(DropTargetDropEvent dtde) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        CharacterData characterData = (CharacterData)this.characterList.getSelectedValue();
        if (characterData == null || !characterData.isValid() || !this.canWriteSamplePicture) {
            tk.beep();
            return;
        }
        try {
            File dropFile = null;
            if (this.canWriteSamplePicture) {
                for (DataFlavor flavor : dtde.getCurrentDataFlavors()) {
                    if (!DataFlavor.javaFileListFlavor.equals(flavor)) continue;
                    dtde.acceptDrop(1);
                    List files = (List)dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    if (files.size() != 1) break;
                    dropFile = (File)files.get(0);
                    break;
                }
            }
            BufferedImage img = null;
            if (dropFile != null && dropFile.isFile() && dropFile.canRead()) {
                try {
                    LoadedImage loadedImage = this.imageLoader.load(new FileImageResource(dropFile));
                    img = loadedImage.getImage();
                }
                catch (IOException ex) {
                    img = null;
                }
            }
            if (img != null) {
                CharacterDataPersistent persist = CharacterDataPersistent.getInstance();
                persist.saveSamplePicture(characterData, img);
                this.sampleImgPanel.setSamplePicture(img);
            } else {
                tk.beep();
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void onClosing() {
        this.dispose();
    }

    protected void onOK() {
        this.selectedCharacterData = (CharacterData)this.characterList.getSelectedValue();
        if (this.selectedCharacterData == null) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        this.dispose();
    }

    protected void onCancel() {
        this.selectedCharacterData = null;
        this.onClosing();
    }

    protected void onProfileNew(boolean makeDefault) {
        CharacterDataPersistent persist = CharacterDataPersistent.getInstance();
        CharacterData cd = (CharacterData)this.characterList.getSelectedValue();
        if (makeDefault || cd == null) {
            cd = persist.createDefaultCharacterData();
        }
        CharacterData newCd = cd.duplicateBasicInfo();
        newCd.setDocBase(null);
        newCd.clearPartsSets(false);
        ProfileEditDialog editDlg = new ProfileEditDialog(this, newCd);
        editDlg.setVisible(true);
        newCd = editDlg.getResult();
        if (newCd == null) {
            return;
        }
        try {
            persist.createProfile(newCd);
            persist.saveFavorites(newCd);
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
            return;
        }
        this.characterListModel.addElement(newCd);
    }

    protected void onProfileEdit() {
        CharacterData cd = (CharacterData)this.characterList.getSelectedValue();
        int rowIndex = this.characterList.getSelectedIndex();
        if (cd == null || !cd.isValid() || rowIndex < 0) {
            return;
        }
        try {
            CharacterData newCd = ProfileListManager.editProfile(this, cd);
            if (newCd == null) {
                return;
            }
            MainFrame.notifyChangeCharacterData(cd, newCd, this);
            this.characterListModel.set(rowIndex, newCd);
            this.characterList.repaint();
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
            return;
        }
    }

    protected void onProfileRemove() {
        CharacterData cd = (CharacterData)this.characterList.getSelectedValue();
        if (cd == null || !cd.isValid() || ProfileListManager.isUsingCharacterData(cd) || !cd.canWrite()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        String msgTempl = strings.getProperty("profile.remove.confirm");
        MessageFormat fmt = new MessageFormat(msgTempl);
        String msg = fmt.format(new Object[]{cd.getName()});
        JPanel msgPanel = new JPanel(new BorderLayout(5, 5));
        msgPanel.add((Component)new JLabel(msg), "Center");
        JCheckBox chkRemoveForce = new JCheckBox(strings.getProperty("profile.remove.force"));
        msgPanel.add((Component)chkRemoveForce, "South");
        JOptionPane optionPane = new JOptionPane(msgPanel, 3, 0){
            private static final long serialVersionUID = 1L;

            public void selectInitialValue() {
                String noBtnCaption = UIManager.getString("OptionPane.noButtonText");
                for (JButton btn : UIHelper.getInstance().getDescendantOfClass(JButton.class, this)) {
                    if (!btn.getText().equals(noBtnCaption)) continue;
                    btn.requestFocus();
                }
            }
        };
        JDialog dlg = optionPane.createDialog(this, strings.getProperty("confirm.remove"));
        dlg.setVisible(true);
        Object ret = optionPane.getValue();
        if (ret == null || ((Number)ret).intValue() != 0) {
            return;
        }
        if (!cd.canWrite() || cd.getDocBase() == null) {
            JOptionPane.showMessageDialog(this, strings.getProperty("profile.remove.cannot"));
            return;
        }
        boolean forceRemove = chkRemoveForce.isSelected();
        try {
            CharacterDataPersistent persiste = CharacterDataPersistent.getInstance();
            persiste.remove(cd, forceRemove);
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
            return;
        }
        this.characterListModel.removeElement(cd);
        this.characterList.repaint();
        this.updateUIState();
    }

    protected void onProfileBrowse() {
        CharacterData cd = (CharacterData)this.characterList.getSelectedValue();
        if (cd == null || !cd.isValid()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        try {
            URI docBase = cd.getDocBase();
            if (!DesktopUtilities.browseBaseDir(docBase)) {
                JOptionPane.showMessageDialog(this, docBase);
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    protected void onProfileImport() {
        try {
            CharacterData cd;
            CharacterData selCd = (CharacterData)this.characterList.getSelectedValue();
            if (selCd != null) {
                Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
                JPanel radioPanel = new JPanel(new BorderLayout());
                JRadioButton btnUpdate = new JRadioButton(strings.getProperty("importToUpdateProfile"));
                JRadioButton btnNew = new JRadioButton(strings.getProperty("importToCreateProfile"));
                ButtonGroup radios = new ButtonGroup();
                radios.add(btnUpdate);
                radios.add(btnNew);
                btnUpdate.setSelected(true);
                radioPanel.add((Component)btnUpdate, "North");
                radioPanel.add((Component)btnNew, "South");
                int ret = JOptionPane.showConfirmDialog(this, radioPanel, strings.getProperty("confirmUpdateProfile"), 2);
                if (ret != 0) {
                    return;
                }
                if (btnNew.isSelected()) {
                    selCd = null;
                }
            }
            if (selCd != null) {
                cd = selCd.duplicateBasicInfo();
                try {
                    ProfileListManager.loadCharacterData(cd);
                    ProfileListManager.loadFavorites(cd);
                }
                catch (IOException ex) {
                    ErrorMessageHelper.showErrorDialog(this, ex);
                }
            } else {
                cd = null;
            }
            ImportWizardDialog importWizDialog = new ImportWizardDialog(this, cd);
            importWizDialog.setVisible(true);
            CharacterData newCd = importWizDialog.getImportedCharacterData();
            if (importWizDialog.getExitCode() == 2) {
                this.characterListModel.addElement(newCd);
            } else if (importWizDialog.getExitCode() == 1) {
                MainFrame.notifyImportedPartsOrFavorites(cd, newCd, this);
            }
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onProfileExport() {
        CharacterData cd = (CharacterData)this.characterList.getSelectedValue();
        if (cd == null || !cd.isValid()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        try {
            CharacterData newCd = cd.duplicateBasicInfo();
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                ProfileListManager.loadCharacterData(newCd);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
            BufferedImage sampleImage = this.sampleImgPanel.getSamplePictrue();
            ExportWizardDialog exportWizDialog = new ExportWizardDialog(this, newCd, sampleImage);
            exportWizDialog.setVisible(true);
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
            return;
        }
    }
}

