/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.io;

import charactermanaj.graphics.io.ImageCache;
import charactermanaj.graphics.io.ImageLoaderImpl;
import charactermanaj.graphics.io.ImageResource;
import charactermanaj.graphics.io.ImageResourceCacheKey;
import charactermanaj.graphics.io.LoadedImage;
import java.io.IOException;

public class ImageCachedLoader
extends ImageLoaderImpl {
    private static ImageCache<ImageResourceCacheKey> caches = new ImageCache();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoadedImage load(ImageResource imageResource) throws IOException {
        if (imageResource == null) {
            throw new IllegalArgumentException();
        }
        ImageResourceCacheKey key = new ImageResourceCacheKey(imageResource);
        ImageCache<ImageResourceCacheKey> imageCache = caches;
        synchronized (imageCache) {
            long lastModified;
            LoadedImage loadedImage = caches.get(key);
            if (loadedImage != null && (lastModified = loadedImage.getLastModified()) != imageResource.lastModified()) {
                loadedImage = null;
            }
            if (loadedImage == null) {
                loadedImage = super.load(imageResource);
                caches.set(key, loadedImage);
                caches.unlockImages();
            }
            return loadedImage;
        }
    }
}

