/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.ColorGroup;

class ColorGroupsTableRow {
    private final String id;
    private final boolean enabled;
    private String localizedName;
    public static final ColorGroupsTableRow NA = new ColorGroupsTableRow("n/a", "", false);

    public ColorGroupsTableRow(String id, String localizedName) {
        this(id, localizedName, true);
    }

    public static ColorGroupsTableRow valueOf(ColorGroup colorGroup) {
        if (colorGroup == null || !colorGroup.isEnabled()) {
            return NA;
        }
        return new ColorGroupsTableRow(colorGroup.getId(), colorGroup.getLocalizedName(), true);
    }

    public ColorGroup convert() {
        if (!this.isEnabled()) {
            return ColorGroup.NA;
        }
        return new ColorGroup(this.getId(), this.getLocalizedName());
    }

    private ColorGroupsTableRow(String id, String localizedName, boolean enabled) {
        if (id == null || id.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.id = id.trim();
        this.localizedName = localizedName == null || localizedName.trim().length() == 0 ? id : localizedName;
        this.enabled = enabled;
    }

    public void setLocalizedName(String localizedName) {
        if (localizedName == null || localizedName.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        if (!this.enabled) {
            throw new UnsupportedOperationException("unmodified object.");
        }
        this.localizedName = localizedName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getId() {
        return this.id;
    }

    public String getLocalizedName() {
        return this.localizedName;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj instanceof ColorGroupsTableRow) {
            ColorGroupsTableRow o = (ColorGroupsTableRow)obj;
            return this.id.equals(o.getId());
        }
        return false;
    }

    public static boolean equals(ColorGroupsTableRow v1, ColorGroupsTableRow v2) {
        if (v1 == v2) {
            return true;
        }
        if (v1 == null || v2 == null) {
            return false;
        }
        return v1.equals(v2);
    }

    public String toString() {
        return this.getLocalizedName();
    }
}

