/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.PartsAuthorInfo;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSpec;
import java.sql.Timestamp;

class PartsManageTableRow {
    private PartsIdentifier partsIdentifier;
    private Timestamp timestamp;
    private String localizedName;
    private String author;
    private String homepage;
    private String downloadURL;
    private double version;

    public PartsManageTableRow(PartsIdentifier partsIdentifier, PartsSpec partsSpec) {
        if (partsIdentifier == null || partsSpec == null) {
            throw new IllegalArgumentException();
        }
        this.partsIdentifier = partsIdentifier;
        this.localizedName = partsIdentifier.getLocalizedPartsName();
        this.timestamp = new Timestamp(partsSpec.getPartsFiles().lastModified());
        PartsAuthorInfo autherInfo = partsSpec.getAuthorInfo();
        if (autherInfo != null) {
            this.author = autherInfo.getAuthor();
            this.homepage = autherInfo.getHomePage();
        }
        if (this.author == null) {
            this.author = "";
        }
        if (this.homepage == null) {
            this.homepage = "";
        }
        this.downloadURL = partsSpec.getDownloadURL();
        this.version = partsSpec.getVersion();
    }

    public PartsIdentifier getPartsIdentifier() {
        return this.partsIdentifier;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public String getLocalizedName() {
        return this.localizedName;
    }

    public void setLocalizedName(String localizedName) {
        if (localizedName == null || localizedName.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.localizedName = localizedName;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getDownloadURL() {
        return this.downloadURL;
    }

    public double getVersion() {
        return this.version;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setDownloadURL(String downloadURL) {
        this.downloadURL = downloadURL;
    }

    public void setVersion(double version) {
        this.version = version;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }
}

