/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model.util;

import charactermanaj.model.util.StartupSupport;
import charactermanaj.util.UserDataFactory;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

class UpgradeCache
extends StartupSupport {
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    UpgradeCache() {
    }

    public void doStartup() {
        UserDataFactory userDataFactory = UserDataFactory.getInstance();
        File appData = userDataFactory.getSpecialDataDir(null);
        for (File file : appData.listFiles()) {
            try {
                File toDir;
                String name = file.getName();
                if (!file.isFile() || !name.endsWith(".ser") || appData.equals(toDir = userDataFactory.getSpecialDataDir(name))) continue;
                String convertedName = this.convertName(name);
                File toFile = new File(toDir, convertedName);
                boolean ret = file.renameTo(toFile);
                this.logger.log(Level.INFO, "move file " + file + " to " + toFile + " ;successed=" + ret);
            }
            catch (Exception ex) {
                this.logger.log(Level.WARNING, "file move failed. " + file, ex);
            }
        }
    }

    protected String convertName(String name) {
        String[] splitedName;
        if ((name.endsWith("-workingset.ser") || name.endsWith("-favorites.ser")) && (splitedName = name.split("-")).length >= 7) {
            StringBuilder buf = new StringBuilder();
            for (int idx = 0; idx < 5; ++idx) {
                if (idx > 0) {
                    buf.append("-");
                }
                buf.append(splitedName[idx]);
            }
            buf.append("-");
            buf.append(splitedName[splitedName.length - 1]);
            return buf.toString();
        }
        return name;
    }
}

