/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.Main;
import charactermanaj.model.AppConfig;
import charactermanaj.model.CharacterData;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.model.PartsSpec;
import charactermanaj.model.io.CharacterDataFileReaderWriterFactory;
import charactermanaj.model.io.CharacterDataWriter;
import charactermanaj.ui.ArchiveFileDialog;
import charactermanaj.ui.ExportInformationPanel;
import charactermanaj.ui.ExportPartsSelectPanel;
import charactermanaj.ui.ExportPresetSelectPanel;
import charactermanaj.util.ErrorMessageHelper;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportWizardDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected static final String STRINGS_RESOURCE = "languages/exportwizdialog";
    protected static ArchiveFileDialog archiveFileDialog = new ArchiveFileDialog();
    private JPanel activePanel;
    private AbstractAction actNext;
    private AbstractAction actPrev;
    private AbstractAction actFinish;
    private ExportInformationPanel basicPanel;
    private ExportPartsSelectPanel partsSelectPanel;
    private ExportPresetSelectPanel presetSelectPanel;
    private CharacterData source;

    public static File getLastUsedDir() {
        return archiveFileDialog.getLastUSedDir();
    }

    public static void setLastUsedDir(File lastUsedDir) {
        archiveFileDialog.setLastUSedDir(lastUsedDir);
    }

    public ExportWizardDialog(JFrame parent, CharacterData characterData, BufferedImage samplePicture) {
        super((Frame)parent, true);
        this.initComponent(parent, characterData, samplePicture);
    }

    public ExportWizardDialog(JDialog parent, CharacterData characterData, BufferedImage samplePicture) {
        super((Dialog)parent, true);
        this.initComponent(parent, characterData, samplePicture);
    }

    private void initComponent(Component parent, CharacterData characterData, BufferedImage samplePicture) {
        if (characterData == null) {
            throw new IllegalArgumentException();
        }
        this.source = characterData;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ExportWizardDialog.this.onClose();
            }
        });
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        this.setTitle(strings.getProperty("title"));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        final JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEtchedBorder());
        final CardLayout mainPanelLayout = new CardLayout(5, 5);
        mainPanel.setLayout(mainPanelLayout);
        contentPane.add((Component)mainPanel, "Center");
        ComponentAdapter componentListener = new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                ExportWizardDialog.this.onComponentShown((JPanel)e.getComponent());
            }
        };
        this.actNext = new AbstractAction(strings.getProperty("btn.next")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                mainPanelLayout.next(mainPanel);
            }
        };
        this.actPrev = new AbstractAction(strings.getProperty("btn.prev")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                mainPanelLayout.previous(mainPanel);
            }
        };
        this.actFinish = new AbstractAction(strings.getProperty("btn.finish")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ExportWizardDialog.this.onFinish();
            }
        };
        AbstractAction actCancel = new AbstractAction(strings.getProperty("btn.cancel")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ExportWizardDialog.this.onClose();
            }
        };
        ChangeListener actChangeValue = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ExportWizardDialog.this.updateBtnPanelState();
            }
        };
        ChangeListener actPanelEnabler = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ExportWizardDialog.this.updatePanelStatus();
            }
        };
        this.basicPanel = new ExportInformationPanel(characterData, samplePicture);
        this.basicPanel.addComponentListener(componentListener);
        this.basicPanel.addChangeListener(actChangeValue);
        this.basicPanel.addChangeListener(actPanelEnabler);
        mainPanel.add((Component)this.basicPanel, "basicPanel");
        this.partsSelectPanel = new ExportPartsSelectPanel(characterData);
        this.partsSelectPanel.addComponentListener(componentListener);
        this.partsSelectPanel.addChangeListener(actChangeValue);
        mainPanel.add((Component)this.partsSelectPanel, "partsSelectPanel");
        this.presetSelectPanel = new ExportPresetSelectPanel(this.partsSelectPanel, this.basicPanel, characterData.getPartsSets().values(), characterData.getDefaultPartsSetId());
        this.presetSelectPanel.addComponentListener(componentListener);
        this.presetSelectPanel.addChangeListener(actChangeValue);
        mainPanel.add((Component)this.presetSelectPanel, "presetSelectPanel");
        JPanel btnPanel = new JPanel();
        btnPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 45));
        GridBagLayout btnPanelLayout = new GridBagLayout();
        btnPanel.setLayout(btnPanelLayout);
        this.actPrev.setEnabled(false);
        this.actNext.setEnabled(false);
        this.actFinish.setEnabled(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        btnPanel.add(Box.createHorizontalGlue(), gbc);
        gbc.gridx = Main.isLinuxOrMacOSX() ? 2 : 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        btnPanel.add((Component)new JButton(this.actPrev), gbc);
        gbc.gridx = Main.isLinuxOrMacOSX() ? 3 : 2;
        gbc.gridy = 0;
        JButton btnNext = new JButton(this.actNext);
        btnPanel.add((Component)btnNext, gbc);
        gbc.gridx = Main.isLinuxOrMacOSX() ? 4 : 3;
        gbc.gridy = 0;
        btnPanel.add((Component)new JButton(this.actFinish), gbc);
        gbc.gridx = Main.isLinuxOrMacOSX() ? 1 : 4;
        gbc.gridy = 0;
        JButton btnCancel = new JButton(actCancel);
        btnPanel.add((Component)btnCancel, gbc);
        contentPane.add((Component)btnPanel, "South");
        JRootPane rootPane = this.getRootPane();
        rootPane.setDefaultButton(btnNext);
        InputMap im = rootPane.getInputMap(2);
        ActionMap am = rootPane.getActionMap();
        im.put(KeyStroke.getKeyStroke(27, 0), "closeExportWizDialog");
        am.put("closeExportWizDialog", actCancel);
        this.setSize(500, 500);
        this.setLocationRelativeTo(parent);
        mainPanelLayout.first(mainPanel);
        this.updateBtnPanelState();
        this.updatePanelStatus();
    }

    protected void onComponentShown(JPanel panel) {
        this.activePanel = panel;
        this.updateBtnPanelState();
    }

    protected void updatePanelStatus() {
        this.partsSelectPanel.setEnabled(this.basicPanel.isExportPartsImages());
        this.presetSelectPanel.setEnabled(this.basicPanel.isExportPresets());
    }

    protected void updateBtnPanelState() {
        this.actPrev.setEnabled(this.activePanel != null && this.activePanel != this.basicPanel);
        this.actNext.setEnabled(this.activePanel != null && this.activePanel != this.presetSelectPanel);
        this.actFinish.setEnabled(this.isComplete());
    }

    protected void checkMissingParts(Collection<PartsSet> partaSets) {
        if (partaSets == null) {
            partaSets = this.presetSelectPanel.getSelectedPresets();
        }
        this.partsSelectPanel.checkMissingPartsList(partaSets);
    }

    protected boolean isComplete() {
        if (this.basicPanel.isExportPartsImages() && this.partsSelectPanel.getSelectedCount() == 0) {
            return false;
        }
        return !this.basicPanel.isExportPresets() || this.presetSelectPanel.getSelectedCount() != 0;
    }

    protected void onClose() {
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        if (JOptionPane.showConfirmDialog(this, strings.getProperty("confirm.close"), strings.getProperty("confirm"), 0, 3) != 0) {
            return;
        }
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onFinish() {
        if (!this.isComplete()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.beep();
            return;
        }
        try {
            File outFile = archiveFileDialog.showSaveDialog(this);
            if (outFile == null) {
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.doExport(outFile);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
            Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
            JOptionPane.showMessageDialog(this, strings.getProperty("complete"));
            this.dispose();
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExport(File outFile) throws IOException {
        CharacterDataFileReaderWriterFactory writerFactory = CharacterDataFileReaderWriterFactory.getInstance();
        CharacterDataWriter exportWriter = writerFactory.createWriter(outFile);
        try {
            CharacterData cd = this.source.duplicateBasicInfo();
            cd.clearPartsSets(false);
            boolean exportPresets = this.basicPanel.isExportPresets();
            boolean exportSamplePicture = this.basicPanel.isExportSamplePicture();
            boolean exportCharacterData = true;
            boolean exportPartsImages = this.basicPanel.isExportPartsImages();
            cd.setAuthor(this.basicPanel.getAuthor());
            cd.setDescription(this.basicPanel.getDescription());
            Properties exportProp = new Properties();
            exportProp.setProperty("EXPORT_PRESETS", Boolean.toString(exportPresets));
            exportProp.setProperty("EXPORT_SAMPLE_PICTURE", Boolean.toString(exportSamplePicture));
            exportProp.setProperty("EXPORT_CHARACTER_DATA", Boolean.toString(exportCharacterData));
            exportProp.setProperty("EXPORT_PARTS_IMAGES", Boolean.toString(exportPartsImages));
            exportProp.setProperty("EXPORT_TIMESTAMP", Long.toString(System.currentTimeMillis()));
            exportWriter.writeExportProp(exportProp);
            if (exportPresets) {
                HashSet<String> registered = new HashSet<String>();
                for (PartsSet partsSet : this.presetSelectPanel.getSelectedPresets()) {
                    registered.add(partsSet.getPartsSetId());
                    cd.addPartsSet(partsSet);
                }
                String defaultPresetId = this.presetSelectPanel.getDefaultPresetId();
                if (registered.contains(defaultPresetId)) {
                    cd.setDefaultPartsSetId(defaultPresetId);
                }
            }
            exportWriter.writeCharacterData(cd);
            String readmeContents = cd.getDescription();
            if (readmeContents != null && readmeContents.trim().length() > 0) {
                AppConfig appConfig = AppConfig.getInstance();
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                pw.println("exported by CharacterManaJ (version " + appConfig.getSpecificationVersion() + " " + appConfig.getImplementationVersion() + ")");
                pw.println();
                pw.println(readmeContents);
                pw.close();
                exportWriter.writeTextUTF16LE("readme.txt", sw.toString());
            }
            if (exportSamplePicture) {
                BufferedImage pic = null;
                pic = this.basicPanel.getSamplePicture();
                if (pic != null) {
                    exportWriter.writeSamplePicture(pic);
                }
            }
            if (exportPartsImages) {
                Map<PartsIdentifier, PartsSpec> partsSpecMap = this.partsSelectPanel.getSelectedParts();
                exportWriter.writePartsManageData(partsSpecMap);
                exportWriter.writePartsImages(partsSpecMap);
            }
        }
        finally {
            exportWriter.close();
        }
    }
}

