/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.model.AppConfig;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSpec;
import charactermanaj.model.PartsSpecResolver;
import charactermanaj.ui.SearchPartsTableModel;
import charactermanaj.ui.model.PartsSelectionManager;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchPartsDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final WeakHashMap<SearchPartsDialog, Object> ALL_DIALOGS = new WeakHashMap();
    protected static final String STRINGS_RESOURCE = "languages/searchpartsdialog";
    private PartsSpecResolver partsSpecResolver;
    private PartsSelectionManager partsSelectionManager;
    private JTable searchPartsTable;
    private SearchPartsTableModel searchPartsTableModel;
    private JTextField txtPartsName;
    private JComboBox cmbAuthors;
    private JComboBox cmbCategories;

    public static SearchPartsDialog[] getDialogs() {
        return ALL_DIALOGS.keySet().toArray(new SearchPartsDialog[ALL_DIALOGS.size()]);
    }

    public SearchPartsDialog(JFrame parent, PartsSpecResolver partsSpecResolver, PartsSelectionManager partsSelectionManager) {
        super((Frame)parent, false);
        if (partsSpecResolver == null) {
            throw new IllegalArgumentException();
        }
        this.partsSpecResolver = partsSpecResolver;
        this.partsSelectionManager = partsSelectionManager;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SearchPartsDialog.this.onClose();
            }
        });
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        this.setTitle(strings.getProperty("title"));
        this.searchPartsTableModel = new SearchPartsTableModel();
        JPanel searchCondPanel = new JPanel();
        GridBagLayout searchCondPanelLayout = new GridBagLayout();
        searchCondPanel.setLayout(searchCondPanelLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        searchCondPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(strings.getProperty("search.condition"))));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        searchCondPanel.add((Component)new JLabel(strings.getProperty("partsname"), 4), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        this.txtPartsName = new JTextField();
        searchCondPanel.add((Component)this.txtPartsName, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        searchCondPanel.add((Component)new JLabel(strings.getProperty("author"), 4), gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        ArrayList<String> authors = new ArrayList<String>();
        authors.add("");
        authors.addAll(this.getAuthors(partsSpecResolver));
        this.cmbAuthors = new JComboBox<String>(authors.toArray(new String[authors.size()]));
        searchCondPanel.add((Component)this.cmbAuthors, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        searchCondPanel.add((Component)new JLabel(strings.getProperty("partscategory"), 4), gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        ArrayList<PartsCategory> categories = new ArrayList<PartsCategory>();
        categories.add(null);
        categories.addAll(partsSpecResolver.getPartsCategories());
        this.cmbCategories = new JComboBox<PartsCategory>(categories.toArray(new PartsCategory[categories.size()]));
        searchCondPanel.add((Component)this.cmbCategories, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.anchor = 15;
        gbc.fill = 2;
        JButton btnClear = new JButton(new AbstractAction(strings.getProperty("clear")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                SearchPartsDialog.this.txtPartsName.setText("");
            }
        });
        searchCondPanel.add((Component)btnClear, gbc);
        JPanel searchResult = new JPanel(new BorderLayout());
        searchResult.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5), BorderFactory.createTitledBorder(strings.getProperty("results"))));
        this.searchPartsTable = new JTable(this.searchPartsTableModel);
        this.searchPartsTable.setShowGrid(true);
        this.searchPartsTable.setGridColor(AppConfig.getInstance().getGridColor());
        JScrollPane searchPartsTableSP = new JScrollPane(this.searchPartsTable);
        this.searchPartsTableModel.adjustColumnModel(this.searchPartsTable.getColumnModel());
        searchResult.add((Component)searchPartsTableSP, "Center");
        this.searchPartsTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    SearchPartsDialog.this.onSelect();
                }
            }
        });
        ActionMap tblAm = this.searchPartsTable.getActionMap();
        InputMap tblIm = this.searchPartsTable.getInputMap();
        tblIm.put(KeyStroke.getKeyStroke(10, 0), "onSelect");
        tblAm.put("onSelect", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                SearchPartsDialog.this.onSelect();
            }
        });
        JPanel btnPanel = new JPanel();
        btnPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 10));
        GridBagLayout btnPanelLayout = new GridBagLayout();
        btnPanel.setLayout(btnPanelLayout);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        btnPanel.add(Box.createHorizontalGlue(), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        JButton btnSelect = new JButton(new AbstractAction(strings.getProperty("select")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                SearchPartsDialog.this.onSelect();
            }
        });
        btnPanel.add((Component)btnSelect, gbc);
        searchResult.add((Component)btnPanel, "South");
        this.txtPartsName.getDocument().addDocumentListener(new DocumentListener(){

            public void removeUpdate(DocumentEvent e) {
                SearchPartsDialog.this.onChangeCondition();
            }

            public void insertUpdate(DocumentEvent e) {
                SearchPartsDialog.this.onChangeCondition();
            }

            public void changedUpdate(DocumentEvent e) {
                SearchPartsDialog.this.onChangeCondition();
            }
        });
        ActionListener changeListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchPartsDialog.this.onChangeCondition();
            }
        };
        this.cmbAuthors.addActionListener(changeListener);
        this.cmbCategories.addActionListener(changeListener);
        JRootPane rootPane = this.getRootPane();
        InputMap im = rootPane.getInputMap(2);
        ActionMap am = rootPane.getActionMap();
        im.put(KeyStroke.getKeyStroke(27, 0), "closeSearchDialog");
        am.put("closeSearchDialog", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                SearchPartsDialog.this.onClose();
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)searchCondPanel, "North");
        contentPane.add((Component)searchResult, "Center");
        this.setSize(250, 300);
        this.setLocationRelativeTo(parent);
        ALL_DIALOGS.put(this, null);
    }

    public List<String> getAuthors(PartsSpecResolver partsSpecResolver) {
        if (partsSpecResolver == null) {
            throw new IllegalArgumentException();
        }
        HashSet<String> authorsSet = new HashSet<String>();
        for (PartsCategory category : partsSpecResolver.getPartsCategories()) {
            for (Map.Entry<PartsIdentifier, PartsSpec> entry : partsSpecResolver.getPartsSpecMap(category).entrySet()) {
                PartsSpec partsSpec = entry.getValue();
                String author = partsSpec.getAuthor();
                if (author == null) continue;
                authorsSet.add(author);
            }
        }
        ArrayList<String> authors = new ArrayList<String>(authorsSet);
        Collections.sort(authors);
        return authors;
    }

    protected void onClose() {
        this.dispose();
    }

    public void adjustLocation(int offset_y) {
        Point pt = this.getParent().getLocation();
        Insets insets = this.getParent().getInsets();
        pt.x += this.getParent().getWidth();
        pt.y += offset_y * insets.top;
        this.setLocation(pt);
        Dimension siz = this.getSize();
        siz.height = this.getParent().getHeight() - offset_y;
        this.setSize(siz);
    }

    protected void onSelect() {
        int selRow = this.searchPartsTable.getSelectedRow();
        if (selRow >= 0) {
            Map.Entry entry = (Map.Entry)this.searchPartsTableModel.getRow(selRow);
            PartsIdentifier partsIdentifier = (PartsIdentifier)entry.getKey();
            this.partsSelectionManager.setSelection(partsIdentifier);
        }
    }

    protected void onChangeCondition() {
        String partsNamesRaw = this.txtPartsName.getText();
        partsNamesRaw = partsNamesRaw.replace("\u3000", " ");
        String[] condPartsNames = partsNamesRaw.split("\\s+");
        PartsCategory condPartsCategory = (PartsCategory)this.cmbCategories.getSelectedItem();
        String condAuthor = (String)this.cmbAuthors.getSelectedItem();
        if (condAuthor != null && condAuthor.trim().length() == 0) {
            condAuthor = null;
        }
        ArrayList<Map.Entry<PartsIdentifier, PartsSpec>> partsIdentifiers = new ArrayList<Map.Entry<PartsIdentifier, PartsSpec>>();
        for (PartsCategory partsCategory : this.partsSpecResolver.getPartsCategories()) {
            if (condPartsCategory != null && !condPartsCategory.equals(partsCategory)) continue;
            for (Map.Entry<PartsIdentifier, PartsSpec> entry : this.partsSpecResolver.getPartsSpecMap(partsCategory).entrySet()) {
                String localizedPartsName;
                String author;
                PartsIdentifier partsIdentifier = entry.getKey();
                PartsSpec partsSpec = entry.getValue();
                if (condAuthor != null && ((author = partsSpec.getAuthor()) == null || !author.equals(condAuthor)) || (localizedPartsName = partsIdentifier.getLocalizedPartsName()) == null) continue;
                for (String condPartsName : condPartsNames) {
                    if (localizedPartsName.indexOf(condPartsName) < 0) continue;
                    partsIdentifiers.add(entry);
                }
            }
        }
        Collections.sort(partsIdentifiers, new Comparator<Map.Entry<PartsIdentifier, PartsSpec>>(){

            @Override
            public int compare(Map.Entry<PartsIdentifier, PartsSpec> o1, Map.Entry<PartsIdentifier, PartsSpec> o2) {
                PartsIdentifier partsIdentifier1 = o1.getKey();
                PartsIdentifier partsIdentifier2 = o2.getKey();
                return partsIdentifier1.compareTo(partsIdentifier2);
            }
        });
        this.searchPartsTableModel.initModel(partsIdentifiers);
    }
}

