/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.util;

import charactermanaj.Main;
import charactermanaj.util.ResourceLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetupLocalization
extends ResourceLoader {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    public static final String DIRNAME_RESOURCES = "resources";
    public static final String CATALOG_NAME = "/resource_list.txt";
    private File baseDir;

    public SetupLocalization(File baseDir) {
        if (baseDir == null || !baseDir.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this.baseDir = baseDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<String> getResourceList() throws IOException {
        ArrayList<String> resources = new ArrayList<String>();
        URL listURL = Main.class.getResource(CATALOG_NAME);
        InputStream is = listURL.openStream();
        try {
            BufferedReader rd = new BufferedReader(new InputStreamReader(is));
            try {
                String line;
                while ((line = rd.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#")) continue;
                    resources.add(line);
                }
            }
            finally {
                rd.close();
            }
        }
        finally {
            is.close();
        }
        this.logger.log(Level.FINE, "resource list: " + resources);
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyResource(URL fromURL, File toFile) throws IOException {
        this.logger.log(Level.INFO, "copy resource '" + fromURL + "' to '" + toFile + "'");
        File dir = toFile.getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("can't create directory. " + dir);
        }
        URLConnection conn = fromURL.openConnection();
        conn.setDoInput(true);
        InputStream is = conn.getInputStream();
        try {
            long lastModified = conn.getLastModified();
            FileOutputStream os = new FileOutputStream(toFile);
            try {
                int rd;
                byte[] buf = new byte[4096];
                while ((rd = is.read(buf)) > 0) {
                    ((OutputStream)os).write(buf, 0, rd);
                }
            }
            finally {
                ((OutputStream)os).close();
            }
            toFile.setLastModified(lastModified);
        }
        finally {
            is.close();
        }
    }

    public File getResourceDir() {
        try {
            return new File(this.baseDir, DIRNAME_RESOURCES).getCanonicalFile();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setupToLocal() throws IOException {
        File toDir = this.getResourceDir();
        ClassLoader cl = this.getDefaultClassLoader();
        for (String resourceName : this.getResourceList()) {
            URL url = cl.getResource(resourceName);
            if (url != null) {
                File toFile = new File(toDir, resourceName).getCanonicalFile();
                this.copyResource(url, toFile);
                continue;
            }
            this.logger.log(Level.WARNING, "missing resource: " + resourceName);
        }
    }
}

