/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.filters;

public class GammaTableFactory {
    private float[] gammas;

    public GammaTableFactory(float gamma) {
        this.setGamma(gamma);
    }

    public GammaTableFactory(float[] gammas) {
        this.setGamma(gammas);
    }

    public final void setGamma(float gamma) {
        this.setGamma(new float[]{gamma, gamma, gamma, gamma});
    }

    public final void setGamma(float[] gammas) {
        if (gammas == null || gammas.length < 3) {
            throw new IllegalArgumentException();
        }
        this.gammas = gammas;
    }

    public int[][] createGammaTable() {
        int mx = this.gammas.length;
        int[][] gammaTbls = new int[mx][];
        for (int i = 0; i < 4; ++i) {
            float gamma = i < mx ? this.gammas[i] : 1.0f;
            gammaTbls[i] = this.createGamma(gamma);
        }
        return gammaTbls;
    }

    private int[] createGamma(float gamma) {
        if (gamma < 0.01f) {
            gamma = 0.01f;
        }
        int[] gammaTbl = new int[256];
        for (int gi = 0; gi <= 255; ++gi) {
            gammaTbl[gi] = (int)(Math.pow((double)gi / 255.0, 1.0f / gamma) * 255.0) & 0xFF;
        }
        return gammaTbl;
    }
}

