/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.io;

import charactermanaj.model.AppConfig;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.event.IIOWriteWarningListener;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class ImageSaveHelper {
    protected static final FileFilter pngFilter = new FileFilter(){

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(".png");
        }

        public String getDescription() {
            return "PNG(*.png)";
        }
    };
    protected static final FileFilter jpegFilter = new FileFilter(){

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(".jpg") || f.getName().endsWith(".jpeg");
        }

        public String getDescription() {
            return "JPEG(*.jpg;*.jpeg)";
        }
    };
    protected File lastUseSaveDir;
    protected FileFilter lastUseFilter = pngFilter;

    public void setLastUseSaveDir(File lastUseSaveDir) {
        this.lastUseSaveDir = lastUseSaveDir;
    }

    public File getLastUsedSaveDir() {
        return this.lastUseSaveDir;
    }

    public File showSaveFileDialog(Component parent) {
        JFileChooser fileChooser = new JFileChooser(this.lastUseSaveDir){
            private static final long serialVersionUID = -9091369410030011886L;

            public void approveSelection() {
                File outFile = this.getSelectedFile();
                if (outFile == null) {
                    return;
                }
                String lcName = outFile.getName().toLowerCase();
                FileFilter selfilter = this.getFileFilter();
                if (selfilter == pngFilter) {
                    if (!lcName.endsWith(".png")) {
                        outFile = new File(outFile.getPath() + ".png");
                        this.setSelectedFile(outFile);
                    }
                } else if (selfilter == jpegFilter && !lcName.endsWith(".jpeg") && !lcName.endsWith(".jpg")) {
                    outFile = new File(outFile.getPath() + ".jpeg");
                    this.setSelectedFile(outFile);
                }
                if (outFile.exists() && JOptionPane.showConfirmDialog(this, "\u4e0a\u66f8\u304d\u3057\u3066\u3082\u3088\u308d\u3057\u3044\u3067\u3059\u304b?", "\u78ba\u8a8d", 0) != 0) {
                    return;
                }
                super.approveSelection();
            }
        };
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter(jpegFilter);
        fileChooser.addChoosableFileFilter(pngFilter);
        if (this.lastUseFilter != pngFilter && this.lastUseFilter != jpegFilter) {
            this.lastUseFilter = pngFilter;
        }
        fileChooser.setFileFilter(this.lastUseFilter);
        int ret = fileChooser.showSaveDialog(parent);
        if (ret != 0) {
            return null;
        }
        File outFile = fileChooser.getSelectedFile();
        this.lastUseSaveDir = outFile.getParentFile();
        this.lastUseFilter = fileChooser.getFileFilter();
        return outFile;
    }

    public void savePicture(BufferedImage img, Color imgBgColor, File outFile, StringBuilder warnings) throws IOException {
        if (img == null || outFile == null) {
            throw new IllegalArgumentException();
        }
        String fname = outFile.getName();
        int extpos = fname.lastIndexOf(".");
        if (extpos < 0) {
            throw new IOException("missing file extension.");
        }
        String ext = fname.substring(extpos + 1).toLowerCase();
        Iterator<ImageWriter> ite = ImageIO.getImageWritersBySuffix(ext);
        if (!ite.hasNext()) {
            throw new IOException("unsupported file extension: " + ext);
        }
        ImageWriter iw = ite.next();
        this.savePicture(img, imgBgColor, iw, outFile, warnings);
    }

    public void savePicture(BufferedImage img, Color imgBgColor, OutputStream outstm, String mime, StringBuilder warnings) throws IOException {
        if (img == null || outstm == null || mime == null) {
            throw new IllegalArgumentException();
        }
        Iterator<ImageWriter> ite = ImageIO.getImageWritersByMIMEType(mime);
        if (!ite.hasNext()) {
            throw new IOException("unsupported mime: " + mime);
        }
        ImageWriter iw = ite.next();
        this.savePicture(img, imgBgColor, iw, outstm, warnings);
        outstm.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void savePicture(BufferedImage img, Color imgBgColor, ImageWriter iw, Object output, final StringBuilder warnings) throws IOException {
        try {
            if (warnings != null) {
                iw.addIIOWriteWarningListener(new IIOWriteWarningListener(){

                    public void warningOccurred(ImageWriter source, int imageIndex, String warning) {
                        if (warnings.length() > 0) {
                            warnings.append(System.getProperty("line.separator"));
                        }
                        warnings.append(warning);
                    }
                });
            }
            boolean jpeg = false;
            boolean png = false;
            for (String mime : iw.getOriginatingProvider().getMIMETypes()) {
                if (mime.contains("image/jpeg")) {
                    jpeg = true;
                    break;
                }
                if (!mime.contains("image/png") && !mime.contains("image/x-png")) continue;
                png = true;
                break;
            }
            ImageWriteParam iwp = iw.getDefaultWriteParam();
            if (jpeg) {
                AppConfig appConfig = AppConfig.getInstance();
                iwp.setCompressionMode(2);
                iwp.setCompressionQuality(appConfig.getCompressionQuality());
            }
            IIOImage ioimg = !png ? new IIOImage(this.createJpegFormatPicture(img, imgBgColor), null, null) : new IIOImage(img, null, null);
            ImageOutputStream bos = ImageIO.createImageOutputStream(output);
            try {
                iw.setOutput(bos);
                iw.write(null, ioimg, iwp);
            }
            finally {
                bos.close();
            }
        }
        finally {
            iw.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage createJpegFormatPicture(BufferedImage img, Color imgBgColor) {
        if (img == null) {
            throw new IllegalArgumentException();
        }
        int w = img.getWidth();
        int h = img.getHeight();
        BufferedImage tmpImg = new BufferedImage(w, h, 4);
        Graphics2D g = tmpImg.createGraphics();
        try {
            if (imgBgColor == null) {
                g.setColor(Color.white);
            } else {
                g.setColor(imgBgColor);
            }
            g.fillRect(0, 0, w, h);
            g.drawImage(img, 0, 0, w, h, 0, 0, w, h, null);
        }
        finally {
            g.dispose();
        }
        return tmpImg;
    }
}

