/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.testing;

import com.google.appengine.api.basement.dev.LocalBasementService;
import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.appengine.tools.development.testing.LocalServiceTestConfig;
import com.google.appengine.tools.development.testing.LocalServiceTestHelper;
import java.io.OutputStream;

public class LocalBasementServiceTestConfig
implements LocalServiceTestConfig {
    private boolean enable = true;
    private boolean ignore = false;
    private boolean logEveryCall = false;
    private OutputStream finalProtoStream = null;

    @Override
    public void setUp() {
        ApiProxyLocal proxy = LocalServiceTestHelper.getApiProxyLocal();
        proxy.setProperty("gae.basement.sawmill.enable", Boolean.toString(this.enable));
        proxy.setProperty("gae.basement.sawmill.ignore", Boolean.toString(this.ignore));
        proxy.setProperty("gae.basement.sawmill.logeverycall", Boolean.toString(this.logEveryCall));
        proxy.setProperty("gae.basement.sawmill.writefinalproto", (this.finalProtoStream != null ? Boolean.TRUE : Boolean.FALSE).toString());
        LocalBasementServiceTestConfig.getLocalBasementService().injectOutputStream(this.finalProtoStream);
    }

    @Override
    public void tearDown() {
    }

    public static LocalBasementService getLocalBasementService() {
        return (LocalBasementService)LocalServiceTestHelper.getLocalService("basement");
    }

    public LocalBasementServiceTestConfig setProtoStream(OutputStream out) {
        this.finalProtoStream = out;
        return this;
    }

    public LocalBasementServiceTestConfig setEnable(boolean b) {
        this.enable = b;
        return this;
    }

    public LocalBasementServiceTestConfig setIgnore(boolean b) {
        this.ignore = b;
        return this;
    }

    public LocalBasementServiceTestConfig setLogEveryCall(boolean b) {
        this.logEveryCall = b;
        return this;
    }
}

