// Chattr - Twitter client on .NET
//
// Copyright (c) 2007 Katsuhiko Ichinose <ichi@users.sourceforge.jp>
//
// Chattr is Free Software released under GNU General Public License.
//
// $Id: IGetProfileImage.cs 106 2008-02-24 13:28:58Z ichi $

using System;
using System.Collections.Generic;
using System.Text;

using System.Windows.Forms;
using System.ComponentModel;
using System.Threading;

namespace Chattr
{
    class IGetProfileImage : IGetHttp
    {
        Mutex m_Mutex;
        DataSetChattrTableAdapters.TableStatusTableAdapter m_Status;
        DataSetChattrTableAdapters.TableProfileImageTableAdapter m_Adapter;
        DataSetChattr m_DataSet;
        Queue<bool> m_Queue;
        Action<string> m_Request;
        Action<bool> m_Exit;
        MethodInvoker m_BeginUpdate;
        MethodInvoker m_EndUpdate;
        Action<int> m_Replase;

        public IGetProfileImage(Mutex mutex, string url, DataSetChattrTableAdapters.TableStatusTableAdapter status,
            DataSetChattrTableAdapters.TableProfileImageTableAdapter adapter,
            DataSetChattr dataSet, Queue<bool> queue, Action<string> request, Action<bool> exit,
            MethodInvoker beginUpdate, MethodInvoker endUpdate, Action<int> replase
            )
            : base(url)
        {
            m_Mutex = mutex;
            m_Status = status;
            m_Adapter = adapter;
            m_DataSet = dataSet;
            m_Queue = queue;
            m_Request = request;
            m_Exit = exit;
            m_BeginUpdate = beginUpdate;
            m_EndUpdate = endUpdate;
            m_Replase = replase;
        }

        public Mutex Mutex
        {
            get
            {
                return m_Mutex;
            }
        }

        public DataSetChattrTableAdapters.TableStatusTableAdapter Status
        {
            get
            {
                return m_Status;
            }
        }

        public DataSetChattrTableAdapters.TableProfileImageTableAdapter Adapter
        {
            get
            {
                return m_Adapter;
            }
        }

        public DataSetChattr DataSet
        {
            get
            {
                return m_DataSet;
            }
        }
        public Queue<bool> Queue
        {
            get
            {
                return m_Queue;
            }
        }

        public Action<string> Request
        {
            get
            {
                return m_Request;
            }
        }

        public Action<bool> Exit
        {
            get
            {
                return m_Exit;
            }
        }

        public MethodInvoker BeginUpdate
        {
            get
            {
                return m_BeginUpdate;
            }
        }

        public MethodInvoker EndUpdate
        {
            get
            {
                return m_EndUpdate;
            }
        }

        public Action<int> Replase
        {
            get
            {
                return m_Replase;
            }
        }
    }
}
