// Chattr - Twitter client on .NET
//
// Copyright (c) 2007 Katsuhiko Ichinose <ichi@users.sourceforge.jp>
//
// Chattr is Free Software released under GNU General Public License.
//
// $Id: IGetTinyUrl.cs 106 2008-02-24 13:28:58Z ichi $

using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;

using System.ComponentModel;

namespace Chattr
{
    class IGetTinyUrl : IGetHttp
    {
        Mutex m_Mutex;
        DataSetChattrTableAdapters.TableTinyUrlTableAdapter m_Adapter;
        DataSetChattr.TableTinyUrlDataTable m_Table;
        Queue<bool> m_Queue;
        Action<string> m_Request;
        Action<bool> m_Exit;

        public IGetTinyUrl(Mutex mutex, string url, DataSetChattrTableAdapters.TableTinyUrlTableAdapter adapter,
            DataSetChattr.TableTinyUrlDataTable table, Queue<bool> queue, Action<string> request, Action<bool> exit
            )
            : base(url)
        {
            m_Mutex = mutex;
            m_Adapter = adapter;
            m_Table = table;
            m_Queue = queue;
            m_Request = request;
            m_Exit = exit;
        }

        public Mutex Mutex
        {
            get
            {
                return m_Mutex;
            }
        }

        public DataSetChattrTableAdapters.TableTinyUrlTableAdapter Adapter
        {
            get
            {
                return m_Adapter;
            }
        }

        public DataSetChattr.TableTinyUrlDataTable Table
        {
            get
            {
                return m_Table;
            }
        }
        public Queue<bool> Queue
        {
            get
            {
                return m_Queue;
            }
        }

        public Action<string> Request
        {
            get
            {
                return m_Request;
            }
        }

        public Action<bool> Exit
        {
            get
            {
                return m_Exit;
            }
        }
    }
}
