// Chattr - Twitter client on .NET
//
// Copyright (c) 2007 Katsuhiko Ichinose <ichi@users.sourceforge.jp>
//
// Chattr is Free Software released under GNU General Public License.
//
// $Id: IListItem.cs 10 2007-09-30 14:34:09Z ichi $

using System;
using System.Collections.Generic;
using System.Text;

namespace Chattr
{
    class IListItem
    {
        private long m_Id;
        private int m_Index;
        private int m_Value;
        private bool m_Delete;

        public IListItem(IListItem item)
        {
            m_Id = item.m_Id;
            m_Index = item.m_Index;
            m_Value = item.m_Value;
            m_Delete = item.m_Delete;
        }

        public IListItem(long id, int index)
        {
            m_Id = id;
            m_Index = index;
            m_Value = 0;
            m_Delete = false;
        }

        public IListItem(long id, int index, int value, bool delete)
        {
            m_Id = id;
            m_Index = index;
            m_Value = value;
            m_Delete = delete;
        }

        public long Id
        {
            get
            {
                return m_Id;
            }
            set
            {
                m_Id = value;
            }
        }

        public int Index
        {
            get
            {
                return m_Index;
            }
            set
            {
                m_Index = value;
            }
        }

        public int Value
        {
            get
            {
                return m_Value;
            }
            set
            {
                m_Value = value;
            }
        }

        public bool Delete
        {
            get
            {
                return m_Delete;
            }
            set
            {
                m_Delete = value;
            }
        }
    }
}
