/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright (c) 2003-2007 by AG-Software 											 *
 * All Rights Reserved.																 *
 * Contact information for AG-Software is available at http://www.ag-software.de	 *
 *																					 *
 * Licence:																			 *
 * The agsXMPP SDK is released under a dual licence									 *
 * agsXMPP can be used under either of two licences									 *
 * 																					 *
 * A commercial licence which is probably the most appropriate for commercial 		 *
 * corporate use and closed source projects. 										 *
 *																					 *
 * The GNU Public License (GPL) is probably most appropriate for inclusion in		 *
 * other open source projects.														 *
 *																					 *
 * See README.html for details.														 *
 *																					 *
 * For general enquiries visit our website at:										 *
 * http://www.ag-software.de														 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

using System;
using System.Text;

using agsXMPP.Xml.Dom;

namespace agsXMPP.protocol.extensions.jingle
{

    /*
    Example 1. Initiation Example

    <iq to='juliet@capulet.com/balcony' from='romeo@montague.net/orchard' id='jingle1' type='set'>
      <jingle xmlns='http://jabber.org/protocol/jingle'
              action='session-initiate'
              initiator='romeo@montague.net/orchard'
              sid='a73sjjvkla37jfea'>
        <content name='this-is-the-audio-content'>
          <description xmlns='http://jabber.org/protocol/jingle/description/audio'>
            ...
          </description>
          <transport xmlns='http://jabber.org/protocol/jingle/transport/ice'>
            ...
          </transport>
          <transport xmlns='http://jabber.org/protocol/jingle/transport/raw-udp'>
            ...
          </transport>
        </content>
        <content name='this-is-the-video-content'>
          <description xmlns='http://jabber.org/protocol/jingle/description/video'>
            ...
          </description>
          <transport xmlns='http://jabber.org/protocol/jingle/transport/ice'>
            ...
          </transport>
          <transport xmlns='http://jabber.org/protocol/jingle/transport/raw-udp'>
            ...
          </transport>
        </content>
      </jingle>
    </iq>
    */
    
    public class Jingle : Element
    {
        public Jingle()
        {
            this.TagName    = "jingle";
            this.Namespace  = Uri.JINGLE;
        }

        /// <summary>
        /// Action, is required
        /// </summary>
        public Action Action
		{
			get 
			{
                string att = GetAttribute("action");
                att = att.Replace("-", "_");
                return (Action) Enum.Parse(typeof(Action), att, false);
			}
			set 
			{
                string val = value.ToString().Replace("_", "-");
				SetAttribute("action", val); 
			}
		}
              
        
        public Jid Initiator
		{
			get { return GetAttributeJid("initiator"); }
			set { SetAttribute("initiator", value);	}
		}

        public Jid Responder
        {
            get { return GetAttributeJid("responder"); }
            set { SetAttribute("responder", value); }
        }
                
        public string Sid
		{
			set	{ SetAttribute("sid", value); }
			get { return GetAttribute("sid"); }
		}

        //public void AddCandidate(Candidate candidate)
        //{
        //    AddChild(candidate);
        //}

        //public Candidate[] GetCandidates()
        //{
        //    ElementList el = SelectElements(typeof(Candidate));
        //    int i = 0;
        //    Candidate[] result = new Candidate[el.Count];
        //    foreach (Candidate cand in el)
        //    {
        //        result[i] = cand;
        //        i++;
        //    }
        //    return result;
        //}
      
    }
}
