package amu;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.network.NetworkMod;

import net.minecraft.src.BaseMod;

@Mod(modid = "AMU", name = "AutoModUpdater", version="開発1")
public class AutoModUpdater {

	/**
	 * 登録されているMODのマップ
	 */
	private static HashMap<String, ModInfo> modMap = new HashMap<String, ModInfo>();

	private static boolean doLogging = true;

	public static void addAMUInfo(String modName, String modVer, String url) {
		modMap.put(modName, new ModInfo(modVer, url));
		logging("AMU Added Mod - " + modName);
	}

	/**
	 * 特定のサイトに接続し、InputStreamから取得した文字列を戻り値として返します。<br>
	 * エラーが発生した場合はnullを返します。
	 * @param urlStr 接続するURL
	 * @param ReqMethod リクエストメソッド
	 * @param variable 指定するパラメータ(cgiへの変数)
	 * @return InputStreamから取得した文字列。エラーが発生した場合はnull
	 */
	public static String connect(String urlStr,String ReqMethod, String... variable) {
		try {
			setDoLogging(false);
			logging("接続開始 " + "URL:" + urlStr);
			//URL設定
			URL url = new URL(urlStr);
			//URL.openConnectionからHttpURLConnection取得
			HttpURLConnection connecter = (HttpURLConnection) url.openConnection();

			//リクエストメソッドをPOSTに設定
			connecter.setRequestMethod(ReqMethod);

			//Inputをtrueに
			connecter.setDoInput(true);
			//Outputをtrueに
			connecter.setDoOutput(true);

			//接続
			connecter.connect();
			logging("接続完了");
			logging("");

			//OutputStreamを取得しDataOutputStreamに
			DataOutputStream wr = new DataOutputStream(
					connecter.getOutputStream());
			//ログインデータ一時書き込み
			for (int i = 0; i < variable.length; i++) {
				wr.writeBytes(variable[i]);
				logging("パラメーター:" + variable[i] + "を設定");
			}
			//書き込み
			wr.flush();
			//クローズ
			wr.close();

			logging("InputStreamにより取得開始");
			//取得
			BufferedReader reader = new BufferedReader(new InputStreamReader(connecter.getInputStream()));
			String str = "";
			String in = null;
			while ((in = reader.readLine()) != null) {
				str = str.concat(String.valueOf(in));
			}
			logging("取得結果:");
			logging(str);

			logging("");

			logging("切断");
			logging("");
			//切断
			connecter.disconnect();

			setDoLogging(true);

			return str;
		} catch (Exception e) {
			return null;
		}
	}

	/**
	 * Loggingします。<br>
	 * ただし、doLoggingがfalseの時はログを取りません。<br>
	 * このメソッドはログを取ったかどうかを返しません。
	 * @param log 出力文字列
	 */
	public static void logging(String log) {
		if (doLogging) System.out.println("[AMU] " + log);
	}

	/**
	 * Loggingするかどうか設定します。
	 * @param doLogging Loggingするか
	 */
	public static void setDoLogging(boolean doLogging) {
		AutoModUpdater.doLogging = doLogging;
	}

	/**
	 * Loggingするかどうか取得します
	 * @return Loggingするかどうか
	 */
	public static boolean doLogging() {
		return doLogging;
	}

}
