package chemicraft;

import net.minecraft.src.Container;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IInventory;
import net.minecraft.src.InventoryPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Slot;
import net.minecraft.src.World;

public class ContainerScienceCraftingTable extends Container
{
    private World worldObj;
    private int posX;
    private int posY;
    private int posZ;

    public ContainerScienceCraftingTable(InventoryPlayer par1InventoryPlayer, TileEntityScienceCraftingTable par2)
    {
        this.worldObj = par2.worldObj;
        this.posX = par2.xCoord;
        this.posY = par2.yCoord;
        this.posZ = par2.zCoord;
        this.addSlotToContainer(new Slot(par2, 0, 10, 10));
    }

    /**
     * Callback for when the crafting matrix is changed.
     */
    public void onCraftMatrixChanged(IInventory par1IInventory)
    {
    }

    /**
     * Callback for when the crafting gui is closed.
     */
    public void onCraftGuiClosed(EntityPlayer par1EntityPlayer)
    {
        super.onCraftGuiClosed(par1EntityPlayer);
    }

    public boolean canInteractWith(EntityPlayer par1EntityPlayer)
    {
        return this.worldObj.getBlockId(this.posX, this.posY, this.posZ) != ChemiCraft.instance.scienceCraftingTableID ? false : par1EntityPlayer.getDistanceSq((double)this.posX + 0.5D, (double)this.posY + 0.5D, (double)this.posZ + 0.5D) <= 64.0D;
    }

    /**
     * Called to transfer a stack from one inventory to the other eg. when shift clicking.
     */
    public ItemStack transferStackInSlot(int par1)
    {
        return null;
    }
}
