package chemicraft;

import java.util.ArrayList;

import net.minecraft.src.ItemStack;

/**
 * ChemiCraftのAPI
 * 基本的にAddonはこのクラスのインスタンスを使う
 * @author mozipi
 *
 */
public class ChemiCraftAPI {

	/**
	 * Instance of the ChemiCraftAPI.
	 */
	public static ChemiCraftAPI instance = new ChemiCraftAPI();


	/**
	 * List of compounds names.
	 */
	private static ArrayList<String> compoundsNameList = new ArrayList();


	/**
	 * List of compounds names(Some kind of language).
	 */
	private static ArrayList<String> compoundsLangNameList = new ArrayList();


	/**
	 * List of compounds the language names.
	 */
	private static ArrayList<String> compoundsLangList = new ArrayList();


	/**
	 * List of compounds handlers.
	 */
	private static ArrayList<ICompoundHandler> compoundHandlers = new ArrayList<ICompoundHandler>();


	/**
	 * List of item name of handler to compounds.
	 */
	private static ArrayList<String> compoundHandlerItemNames = new ArrayList<String>();


	/**
	 * 分解台の素材のリスト
	 */
	private static ArrayList<ItemStack> decompositionMaterial = new ArrayList<ItemStack>();


	/**
	 * 分解台の結果のリスト
	 */
	private static ArrayList<ItemStack[]> decompositionResults = new ArrayList<ItemStack[]>();


	/**
	 * 化合台の素材のリスト
	 */
	private static ArrayList<ItemStack[]> chemicalCombinationMaterials = new ArrayList<ItemStack[]>();


	/**
	 * 化合台の結果のリスト
	 */
	private static ArrayList<ItemStack> chemicalCombinationResult = new ArrayList<ItemStack>();



	/**
	 * ChemiCraftの化学作業台類のレシピのマネージャー
	 */
	private static ChemiCraftCraftingManager chemiCraftCraftingManager = new ChemiCraftCraftingManager();



	/**
	 * add compound.
	 * @param name compound name.
	 */
	public static void addCompound(String name){
		compoundsNameList.add(name);
		compoundsLangNameList.add("");
		compoundsLangList.add("");
	}



	/**
	 * add compound corresponding to the language.
	 * @param lang Language to the corresponding
	 * @param englishName compound name
	 * @param langName compound name(specified language)
	 */
	public static void addLangCompound(String lang, String englishName, String langName){
		compoundsNameList.add(englishName);
		compoundsLangNameList.add(langName);
		compoundsLangList.add(lang);
	}



	/**
	 * setting compound handler.
	 * @param handlerItemName
	 * @param compoundHandler
	 */
	public static void settingCompoundHandler(String handlerItemName, ICompoundHandler compoundHandler){
		ChemiCraftAPI.compoundHandlers.add(compoundHandler);
		compoundHandlerItemNames.add(handlerItemName);
	}



	/**
	 * 分解レシピを追加します。resultの要素数は0<= n <= 16にしてください。
	 * @param material 素材
	 * @param result 結果
	 */
	public static void addDecompositionRecipe(ItemStack material, ItemStack[] result){
		if(result.length <= 16){
			decompositionMaterial.add(material);
			decompositionResults.add(result);
		}else{
			System.err.println("ChemiCraft内でエラー:addDecompositionRecipeの引数resultの要素数が16を超えています。" + "Material:" + material + "  Result:" + result);
		}
	}



	/**
	 * 化合レシピを追加します。materialの要素数は0<= n <= 16にしてください。
	 * @param material 素材
	 * @param result 結果
	 */
	public static void addChemicalCombinationRecipe(ItemStack[] material, ItemStack result){
		if(material.length <= 16){
			chemicalCombinationMaterials.add(material);
			chemicalCombinationResult.add(result);
		}else{
			System.err.println("ChemiCraft内でエラー:addChemicalCombinationRecipeの引数materialの要素数が16を超えています。" + "Material:" + material + "  Result:" + result);
		}
	}
	//以下システム関連//////////////////////////////////////////////////////

	public static ArrayList<ICompoundHandler> getCompoundHandler(){
		compoundHandlers.trimToSize();
		return compoundHandlers;

	}



	public static ArrayList<String> getCompoundHandlerItemName(){
		compoundHandlerItemNames.trimToSize();
		return compoundHandlerItemNames;
	}



	public static ArrayList<String> getCompoundsName(){
		compoundsNameList.trimToSize();
		return compoundsNameList;
	}



	public static ArrayList<String> getCompoundsLangName(){
		compoundsLangNameList.trimToSize();
		return compoundsLangNameList;
	}



	public static ArrayList<String> getCompoundsLang(){
		compoundsLangList.trimToSize();
		return compoundsLangList;
	}



	public static ArrayList<ItemStack> getDecompositionMaterial(){
		return decompositionMaterial;
	}



	public static ArrayList<ItemStack[]> getDecompositionResult(){
		return decompositionResults;
	}



	public static ArrayList<ItemStack[]> getChemicalCombinationMaterial(){
		return chemicalCombinationMaterials;
	}



	public static ArrayList<ItemStack> getChemicalCombinationResult(){
		return chemicalCombinationResult;
	}



	public static ChemiCraftCraftingManager getCraftingManager(){
		return chemiCraftCraftingManager;
	}

}
