package chemicraft;

import java.util.ArrayList;
import java.util.HashMap;

import net.minecraft.src.Block;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.GuiButton;
import net.minecraft.src.GuiContainer;
import net.minecraft.src.InventoryBasic;
import net.minecraft.src.InventoryPlayer;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.StatCollector;
import cpw.mods.fml.common.Side;
import cpw.mods.fml.common.asm.SideOnly;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;

@SideOnly(Side.CLIENT)
public class GuiDecompositionTable extends GuiContainer {

	/**
	 * the TileEntity.
	 */
	private TileEntityDecompositionTable tileEntity;

	/**
	 * the InventoryPlayer.
	 */
	private InventoryPlayer inventoryPlayer;

	/**
	 * the Container
	 */
	private ContainerDecompositionTable container;

	public GuiDecompositionTable(EntityPlayer par1EntityPlayer,
			TileEntityDecompositionTable par2) {
		super(new ContainerDecompositionTable(par1EntityPlayer, par2));
		this.inventoryPlayer = par1EntityPlayer.inventory;
		this.tileEntity = par2;
		this.container = (ContainerDecompositionTable) this.inventorySlots;
	}

	@Override
	public void initGui() {
		super.initGui();
		this.controlList.add(new GuiButton(0, this.guiLeft + 17,
				this.guiTop + 4, 60, 16, "TakeOut"));
	}

	@Override
	protected void drawGuiContainerBackgroundLayer(float par1, int par2,
			int par3) {
		this.mc.renderEngine.bindTexture(this.mc.renderEngine
				.getTexture(ChemiCraft.instance.guiDecompositionTexture));
		this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize,
				this.ySize);
	}

	@Override
	protected void actionPerformed(GuiButton par1GuiButton) {
		this.container.onButtonClick(par1GuiButton.id);
	}

}
