package chemicraft;

import net.minecraft.src.Block;
import net.minecraft.src.CreativeTabs;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;
import chemicraft.Auxiliary.NameAuxiliary;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;

/**
 * ChemiCraft本体
 *
 * @author P.C.C.
 *
 */
@Mod(modid = "chemiCraft", name = "ChemiCraft", version = "beta")
// ID,名前,バージョン
@NetworkMod(clientSideRequired = true, serverSideRequired = false, versionBounds = "1.3.2", channels = "chemicraft", packetHandler = PacketHandler.class)
// クライアント、サーバー共に必要 1.3.2用
public class ChemiCraft {

	public final String[] atomsName = { "Hydrogen", "Helium", "Lithium", "Beryllium", "Boron", "Carbon", "Nitrogen", "Oxygen", "Fluorine", "Neon", "Sodium", "Magnesium", "Aluminium", "Silicon",
			"Phosphorus", "Sulfur", "Chlorine", "Argon", "Potassium", "Calcium", "Scandium", "Titanium", "Vanadium", "Chromium", "Manganese", "Iron", "Cobalt", "Nickel", "Copper", "Zinc", "Gallium",
			"Germanium", "Arsenic", "Selenium", "Bromine", "Krypton", "Rubidium", "Strontium", "Yttorium", "Zirconium", "Niobium", "Molybdenum", "Technetium", "Ruthenium", "Rhodium", "Palladium",
			"Silver", "Cadmium", "Indium", "Tin", "Antimony", "Tellurium", "Iodine", "Xenon", "Caesium", "Barium", "Lanthanum", "Cerium", "Praseodymium", "Neodymium", "Promethium", "Samarium",
			"Europium", "Gadolinium", "Terbium", "Dysprosium", "Holmium", "Erbium", "Thulium", "Ytterbium", "Lutetium", "Hafnium", "Tantalum", "Tungsten", "Rhenium", "Osmium", "Iridium", "Platinum",
			"Gold", "Mercury", "Thallium", "Lead", "Bismuth", "Polonium", "Astatine", "Radon", "Francium", "Radium", "Actinium", "Thorium", "Protactinium", "Uranium", "Neptunium", "Plutonium",
			"Americium", "Curium", "Berkelium", "Californium", "Einsteinium", "Fermium", "Mendelevium", "Nobelium", "Lawrencium", "Rutherfordium", "Dubnium", "Seaborgium", "Bohrium", "Hassium",
			"Meitnerium", "Darmstadtium", "Roentgenium", "Copernicium", "Ununtrium", "Ununquadium", "Ununpentium", "Ununhexium", "Ununseptium", "Ununoctium" };

	public final String[] atomsNameJP = { "水素", "ヘリウム", "リチウム", "ベリウム", "ホウ素", "炭素", "窒素", "酸素", "フッ素", "ネオン", "ナトリウム", "マグネシウム", "アルミニウム", "ケイ素", "リン", "硫黄", "塩素", "アルゴン", "カリウム", "カルシウム", "スカンジウム",
			"チタン", "バナジウム", "クロム", "マンガン", "鉄", "コバルト", "ニッケル", "銅", "亜鉛", "ガリウム", "ゲルマニウム", "ヒ素", "セレン", "臭素", "クリプトン", "ルビジウム", "ストロンチウム", "イットリウム", "ジルコニウム", "ニオブ", "モリブデン", "テクネチウム", "ルテニウム",
			"ロジウム", "パラジウム", "銀", "カドミウム", "インジウム", "スズ", "アンチモン", "テルル", "ヨウ素", "キセノン", "セシウム", "バリウム", "ランタン", "セリウム", "プラセオジム", "ネオジム", "プロメチウム", "サマリウム", "ユウロビウム", "ガドリニウム", "テルビウム", "ジスプロニウム",
			"ホルミウム", "エルビウム", "ツリウム", "イッテルビウム", "ルテチウム", "ハフニウム", "タンタル", "タングステン", "レニウム", "オスミウム", "イリジウム", "白金", "金", "水銀", "タリウム", "鉛", "ビスマス", "ポロニウム", "アスタチン", "ラドン", "フランシウム", "ラジウム",
			"アクチニウム", "トリウム", "プロトアクチウム", "ウラン", "ネプツニウム", "プルトニウム", "アメリシウム", "キュリウム", "バークリウム", "カルホルニウム", "アインスタイニウム", "フェルミウム", "メンデレビウム", "ノーベリウム", "ローレンシウム", "ラサホージウム", "ドブニウム", "シーボーギウム",
			"ボーリウム", "ハッシウム", "マイトネリウム", "ダームスタチウム", "レントゲニウム", "コペルニシウム", "ウンウントリウム", "ウンウンクアジウム", "ウンウンペンチウム", "ウンウンヘキシウム", "ウンウンセプチウム", "ウンウンオクチウム" };

	/**
	 * このmodのインスタンス
	 */
	@Mod.Instance("chemiCraft")
	public static ChemiCraft instance;

	/**
	 * ChemiCraftのProxy
	 */
	@SidedProxy(clientSide = "chemicraft.client.ClientProxy", serverSide = "chemicraft.CommonProxy")
	public static CommonProxy proxy;

	/**
	 * ChemiCraftのCreativeTab
	 */
	public CreativeTabs creativeTab = new CreativeTabAtoms("ChemiCraft");

	/**
	 * ItemID
	 */
	public int atomsID;
	public int compoundsID;
	public int gasCollectingBottleID;
	public int atomGrenadeID;

	/**
	 * BlockID
	 */
	public int decompositionTableID;
	public int chemicalConbinationTableID;
	public int toolAndWeaponCraftingTableID;
	public int materialCraftingTableID;

	/**
	 * GUIID
	 */
	public int guiDecompositionTableID;
	public int guiChemicalCombinationTableID;
	public int guiToolAndWeaponCraftingTableID;
	public int guiMaterialCraftingTableID;

	/**
	 * Block型変数
	 */
	public static Block blockDecompositionTable;
	public static Block blockChemicalCombinationTable;
	public static Block blockToolAndWeaponCraftingTable;
	public static Block blockMaterialCraftingTable;

	/**
	 * Item型変数
	 */
	public static Item itemAtoms;
	public static Item itemCompounds;
	public static Item itemGasCollectingBottle;
	public static Item itemAtomGrenade;

	/**
	 * このmodで使用するTextureのパス
	 */
	public String itemAtomsTexture = "/chemicraft/items/Atoms.png";
	public String itemCompoundsTexture = "/chemicraft/items/Compounds.png";
	public String itemTexture = "/chemicraft/items/items.png";
	public String blockChemicalCraftingTableTexture = "/chemicraft/blocks/CCTable.png";
	public String guiDecompositionTexture = "/chemicraft/guis/Decomposition.png";
	public String guiChemicalCombinationTexture = "/chemicraft/guis/ChemicalCombination.png";
	public String guiToolAndWeaponCraftingTexture = "/chemicraft/guis/ToolAndWeaponCrafting.png";
	public String guiMaterialCraftingTexture = "/chemicraft/guis/MaterialCrafting.png";

	/**
	 * このmodに必要な補助クラスのインスタンス
	 */
	private Auxiliary Auxiliary = new Auxiliary();
	private NameAuxiliary NameAuxiliary = Auxiliary.new NameAuxiliary();

	@Mod.PreInit
	public void chemiPreLoadMethod(FMLPreInitializationEvent event) {
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		cfg.load();

		Property decompositionTableIDProp = cfg.getBlock("DecompositionTable", 2400);
		Property chemicalCombinationTableIDProp = cfg.getBlock("ChemicalCombinationID", 2401);
		Property toolAndWeaponCraftingTableIDProp = cfg.getBlock("ToolAndWeaponCraftingTableID", 2402);
		Property materialCraftingTableIDProp = cfg.getBlock("MaterialCraftingTableID", 2403);

		Property atomsIDProp = cfg.getItem("AtomsID", 25000);
		Property compoundsIDProp = cfg.getItem("CompoundsID", 25001);
		Property gasCollectingBottleIDProp = cfg.getItem("gasCollectingBottleID", 25002);
		Property atomGrenadeIDProp = cfg.getItem("AtomGrenadeID", 25003);

		Property guiDecompositionTableIDProp = cfg.get("GUI", "GUIChemicalCraftingTableID", 1000);
		Property guiChemicalCombinationTableIDProp = cfg.get("GUI", "GUIChemicalCombinationTableID", 1001);
		Property guiToolAndWeaponCraftingTableIDProp = cfg.get("GUI", "GUIToolAndWeaponCraftingTableID", 1002);
		Property guiMaterialCraftingTableIDProp = cfg.get("GUI", "GUIMaterialCraftingTableID", 1003);


		this.decompositionTableID = decompositionTableIDProp.getInt();
		this.chemicalConbinationTableID = chemicalCombinationTableIDProp.getInt();
		this.toolAndWeaponCraftingTableID = toolAndWeaponCraftingTableIDProp.getInt();
		this.materialCraftingTableID = materialCraftingTableIDProp.getInt();
		this.atomsID = atomsIDProp.getInt();
		this.compoundsID = compoundsIDProp.getInt();
		this.gasCollectingBottleID = gasCollectingBottleIDProp.getInt();
		this.atomGrenadeID = atomGrenadeIDProp.getInt();
		this.guiDecompositionTableID = guiDecompositionTableIDProp.getInt();
		this.guiChemicalCombinationTableID = guiChemicalCombinationTableIDProp.getInt();
		this.guiToolAndWeaponCraftingTableID = guiToolAndWeaponCraftingTableIDProp.getInt();
		this.guiMaterialCraftingTableID = guiMaterialCraftingTableIDProp.getInt();

		cfg.save();

		// 描画関係の読み込み
		proxy.registerRenderInformation();
	}


	@Mod.PostInit
	public void chemiPostLoadMethod(FMLPostInitializationEvent event) {
		this.settingProcessing(event);
		this.apiProcessing(event);
	}

	private void settingProcessing(FMLPostInitializationEvent event){
		// Blockを追加します
		this.blockDecompositionTable = new BlockDecompositionTable(this.decompositionTableID, 0, Material.ground).setHardness(2.0F).setResistance(0.0F).setStepSound(Block.soundStoneFootstep).setBlockName("DecompositionTable");
		this.blockChemicalCombinationTable = new BlockChemicalCombinationTable(this.chemicalConbinationTableID, 0, Material.ground).setHardness(2.0F).setResistance(0.0F).setStepSound(Block.soundStoneFootstep).setBlockName("ChemicalCombinationTable");
		this.blockToolAndWeaponCraftingTable = new BlockToolAndMaterialCraftingTable(this.toolAndWeaponCraftingTableID, 0, Material.ground).setHardness(2.0F).setResistance(0.0F).setStepSound(Block.soundStoneFootstep).setBlockName("ToolAndWeaponCraftingTable");
		this.blockMaterialCraftingTable = new BlockMaterialCraftingTable(materialCraftingTableID, 0, Material.ground).setHardness(2.0F).setResistance(0.0F).setStepSound(Block.soundStoneFootstep).setBlockName("MaterialCraftingTable");


		// Itemを追加します
		this.itemAtoms = new ItemAtoms(this.atomsID).setItemName("atoms");
		this.itemCompounds = new ItemCompounds(this.compoundsID).setItemName("compounds");
		this.itemGasCollectingBottle = new ItemGasCollectingBottle(this.gasCollectingBottleID).setItemName("gasCollectingBottle").setIconIndex(0);
		this.itemAtomGrenade = new ItemAtomGrenade(this.atomGrenadeID).setItemName("grenade").setIconIndex(1);

		// BlockをMinecraftに登録します
		GameRegistry.registerBlock(this.blockDecompositionTable);
		GameRegistry.registerBlock(this.blockChemicalCombinationTable);
		GameRegistry.registerBlock(this.blockToolAndWeaponCraftingTable);
		GameRegistry.registerBlock(this.blockMaterialCraftingTable);

		// Blockの名前を設定します
		this.NameAuxiliary.addName(this.blockDecompositionTable, "DecompositionTable");
		this.NameAuxiliary.addName(this.blockDecompositionTable, "ja_JP", "分解台");
		this.NameAuxiliary.addName(this.blockChemicalCombinationTable, "ChemicalCombinationTable");
		this.NameAuxiliary.addName(this.blockChemicalCombinationTable, "ja_JP", "化合台");
		this.NameAuxiliary.addName(blockToolAndWeaponCraftingTable, "ToolAndWeaponCraftingTable");
		this.NameAuxiliary.addName(blockToolAndWeaponCraftingTable, "ja_JP", "ツール&武器製作台");
		this.NameAuxiliary.addName(blockMaterialCraftingTable, "MaterialCraftingTable");
		this.NameAuxiliary.addName(blockMaterialCraftingTable, "ja_JP", "素材製作台");


		// Itemの名前を設定します
		this.NameAuxiliary.addName(this.itemAtoms, atomsName);
		this.NameAuxiliary.addName(this.itemAtoms, "ja_JP", atomsNameJP);
		this.NameAuxiliary.addName(this.itemGasCollectingBottle, "GasCollectingBottle");
		this.NameAuxiliary.addName(this.itemGasCollectingBottle, "ja_JP", "集気瓶");
		this.NameAuxiliary.addName(this.itemAtomGrenade, "AtomGrenade");
		this.NameAuxiliary.addName(this.itemAtomGrenade, "元素手榴弾");

		// TileEntityを追加します
		GameRegistry.registerTileEntity(TileEntityDecompositionTable.class, "DecompositionTable");
		GameRegistry.registerTileEntity(TileEntityChemicalCombinationTable.class, "TileEntityChemicalCombinationTable");
		GameRegistry.registerTileEntity(TileEntityToolAndWeaponCraftingTable.class, "TileEntityToolAndWeaponCraftingTable");
		GameRegistry.registerTileEntity(TileEntityMaterialCraftingTable.class, "TileEntityMaterialCraftingTable");

		// GUIを追加します
		NetworkRegistry.instance().registerGuiHandler(instance, proxy);

		//Textureをpreloadします
		proxy.registerTextures();

		//化学作業台類のレシピを追加します
		GameRegistry.addRecipe(new ItemStack(this.blockDecompositionTable),
				new Object[]{
			"XYX", "ZAZ", "ZZZ",
			new Character('X'), new ItemStack(Item.ingotIron),
			new Character('Y'), new ItemStack(Block.workbench),
			new Character('Z'), new ItemStack(Block.stone),
			new Character('A'), new ItemStack(Block.tnt),
		});
		GameRegistry.addRecipe(new ItemStack(this.blockChemicalCombinationTable),
				new Object[]{
			"XYX", "ZAZ", "ZZZ",
			new Character('X'), new ItemStack(Item.ingotIron),
			new Character('Y'), new ItemStack(Block.workbench),
			new Character('Z'), new ItemStack(Block.stone),
			new Character('A'), new ItemStack(Block.obsidian),
		});
		GameRegistry.addRecipe(new ItemStack(this.blockToolAndWeaponCraftingTable),
				new Object[]{
			"XYX", "ZAZ", "ZZZ",
			new Character('X'), new ItemStack(Item.ingotIron),
			new Character('Y'), new ItemStack(Block.workbench),
			new Character('Z'), new ItemStack(Block.stone),
			new Character('A'), new ItemStack(Item.pickaxeSteel),
		});
		GameRegistry.addRecipe(new ItemStack(this.blockMaterialCraftingTable),
				new Object[]{
			"XYX", "ZAZ", "ZZZ",
			new Character('X'), new ItemStack(Item.ingotIron),
			new Character('Y'), new ItemStack(Block.workbench),
			new Character('Z'), new ItemStack(Block.stone),
			new Character('A'), new ItemStack(this.itemAtoms, 1, 0),
		});

		//手榴弾の追加
		ChemiCraftAPI.instance.addMaterialRecipe(new ItemStack[]{new ItemStack(Item.gunpowder)}, new ItemStack(this.itemAtomGrenade, 16, 0), new NBTRecipeGrenade());

	}

	private void apiProcessing(FMLPostInitializationEvent event){
		// API用の処理
		this.NameAuxiliary.addName(itemCompounds, ChemiCraftAPI.instance.getCompoundsName().toArray());
		this.NameAuxiliary.addName(itemCompounds, "ja_JP", ChemiCraftAPI.instance.getCompoundsLangName().toArray());
	}

	public final static int HYDROGEN = 0;
	public final static int HELIUM = 1;
	public final static int LITHIUM = 2;
	public final static int BERYLLIUM = 3;
	public final static int BORON = 4;
	public final static int CARBON = 5;
	public final static int NITROGEN = 6;
	public final static int OXYGEN = 7;
	public final static int URANIUM = 91;

}