package chemicraft;

import java.util.ArrayList;

import net.minecraft.src.ItemStack;

/**
 * ChemiCraftのAPI
 * 基本的にAddonはこのクラスのインスタンスを使う
 * @author mozipi
 *
 */
public class ChemiCraftAPI {

	/**
	 * Instance of the ChemiCraftAPI.
	 */
	public static ChemiCraftAPI instance = new ChemiCraftAPI();


	/**
	 * List of compounds names.
	 */
	private ArrayList<String> compoundsNameList = new ArrayList();


	/**
	 * List of compounds names(Some kind of language).
	 */
	private ArrayList<String> compoundsLangNameList = new ArrayList();


	/**
	 * List of compounds the language names.
	 */
	private ArrayList<String> compoundsLangList = new ArrayList();


	/**
	 * List of compounds handlers.
	 */
	private ArrayList<ICompoundHandler> compoundHandlers = new ArrayList<ICompoundHandler>();


	/**
	 * List of item name of handler to compounds.
	 */
	private ArrayList<String> compoundHandlerItemNames = new ArrayList<String>();


	/**
	 * 分解台の素材のリスト
	 */
	private ArrayList<ItemStack> decompositionMaterial = new ArrayList<ItemStack>();


	/**
	 * 分解台の結果のリスト
	 */
	private ArrayList<ItemStack[]> decompositionResults = new ArrayList<ItemStack[]>();


	/**
	 * 化合台の素材のリスト
	 */
	private ArrayList<ItemStack[]> chemicalCombinationMaterials = new ArrayList<ItemStack[]>();


	/**
	 * 化合台の結果のリスト
	 */
	private ArrayList<ItemStack> chemicalCombinationResult = new ArrayList<ItemStack>();



	/**
	 * 素材製作台の効果添付素材のリスト
	 */
	private ArrayList<ItemStack[]> materialEffectMaterials = new ArrayList<ItemStack[]>();



	/**
	 * 素材製作台の素材のリスト
	 */
	private ArrayList<ItemStack[]> materialMaterials = new ArrayList<ItemStack[]>();



	/**
	 * 素材製作台の結果のリスト
	 */
	private ArrayList<ItemStack> materialResult = new ArrayList<ItemStack>();



	/**
	 * 素材製作台の効果付属用のNBTRecipeのリスト
	 */
	private ArrayList<NBTRecipe> materialNBT = new ArrayList<NBTRecipe>();



	/**
	 * ChemiCraftの化学作業台類のレシピのマネージャー
	 */
	private ChemiCraftCraftingManager chemiCraftCraftingManager = new ChemiCraftCraftingManager();



	/**
	 * add compound.
	 * @param name compound name.
	 */
	public void addCompound(String name){
		compoundsNameList.add(name);
		compoundsLangNameList.add("");
		compoundsLangList.add("");
	}



	/**
	 * add compound corresponding to the language.
	 * @param lang Language to the corresponding
	 * @param englishName compound name
	 * @param langName compound name(specified language)
	 */
	public void addLangCompound(String lang, String englishName, String langName){
		compoundsNameList.add(englishName);
		compoundsLangNameList.add(langName);
		compoundsLangList.add(lang);
	}



	/**
	 * setting compound handler.
	 * @param handlerItemName
	 * @param compoundHandler
	 */
	public void settingCompoundHandler(String handlerItemName, ICompoundHandler compoundHandler){
		compoundHandlers.add(compoundHandler);
		compoundHandlerItemNames.add(handlerItemName);
	}



	/**
	 * 分解レシピを追加します。resultの要素数は0<= n <= 16にしてください。
	 * @param material 素材
	 * @param result 結果
	 */
	public void addDecompositionRecipe(ItemStack material, ItemStack[] result){
		if(result.length <= 16){
			decompositionMaterial.add(material);
			decompositionResults.add(result);
		}else{
			System.err.println("ChemiCraft内でエラー:addDecompositionRecipeの引数resultの要素数が16を超えています。" + "Material:" + material + "  Result:" + result);
		}
	}



	/**
	 * 化合レシピを追加します。materialの要素数は0<= n <= 16にしてください。
	 * @param material 素材
	 * @param result 結果
	 */
	public void addChemicalCombinationRecipe(ItemStack[] material, ItemStack result){
		if(material.length <= 16){
			chemicalCombinationMaterials.add(material);
			chemicalCombinationResult.add(result);
		}else{
			System.err.println("ChemiCraft内でエラー:addChemicalCombinationRecipeの引数materialの要素数が16を超えています。" + "Material:" + material + "  Result:" + result);
		}
	}



	public void addMaterialRecipe(ItemStack[] materials, ItemStack result, NBTRecipe nbtRecipe){
		if(materials.length <= 9){
			materialMaterials.add(materials);
			materialResult.add(result);
			materialNBT.add(nbtRecipe);
		}else{
			System.err.println("ChemiCraft内でエラー:addMaterialRecipeの引数materialsの要素数が9を超えています。" + "Material:" + materials + " Result:" + result);
		}
	}
	//以下システム関連//////////////////////////////////////////////////////

	public ArrayList<ICompoundHandler> getCompoundHandler(){
		compoundHandlers.trimToSize();
		return compoundHandlers;

	}



	public ArrayList<String> getCompoundHandlerItemName(){
		compoundHandlerItemNames.trimToSize();
		return compoundHandlerItemNames;
	}



	public ArrayList<String> getCompoundsName(){
		compoundsNameList.trimToSize();
		return compoundsNameList;
	}



	public ArrayList<String> getCompoundsLangName(){
		compoundsLangNameList.trimToSize();
		return compoundsLangNameList;
	}



	public ArrayList<String> getCompoundsLang(){
		compoundsLangList.trimToSize();
		return compoundsLangList;
	}



	public ArrayList<ItemStack> getDecompositionMaterial(){
		return decompositionMaterial;
	}



	public ArrayList<ItemStack[]> getDecompositionResult(){
		return decompositionResults;
	}



	public ArrayList<ItemStack[]> getChemicalCombinationMaterial(){
		return chemicalCombinationMaterials;
	}



	public ArrayList<ItemStack> getChemicalCombinationResult(){
		return chemicalCombinationResult;
	}



	public ArrayList<ItemStack[]> getMaterialMaterials(){
		return materialMaterials;
	}



	public ArrayList<ItemStack> getMaterialResult(){
		return materialResult;
	}



	public ArrayList<NBTRecipe> getMaterialNBTRecipe(){
		return materialNBT;
	}



	public ChemiCraftCraftingManager getCraftingManager(){
		return chemiCraftCraftingManager;
	}

}
