package chemicraft;

import net.minecraft.src.Container;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IInventory;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Slot;
import net.minecraft.src.World;

public class ContainerChemicalCombinationTable extends Container {

	/**
	 * Worldのインスタンス
	 */
	private World worldObj;


	/**
	 * BlockのX, Y, Z座標
	 */
	private int posX;
	private int posY;
	private int posZ;


	/**
	 * the TileEntity.
	 */
	private TileEntityChemicalCombinationTable tileEntity;


	/**
	 * the inventory.
	 */
	private IInventory inv;



	public ContainerChemicalCombinationTable(EntityPlayer par1EntityPlayer, TileEntityChemicalCombinationTable par2)
	{
		super();
		this.worldObj = par2.worldObj;
		this.posX = par2.xCoord;
		this.posY = par2.yCoord;
		this.posZ = par2.zCoord;
		this.tileEntity = par2;
		this.inv = par2.getInventorys();
		//GenerateInventory
		this.generateSlots("ChemicalCombination", par2.getInventorys());
		//GeneratePlayerInventory
		int var3;

		for (var3 = 0; var3 < 3; ++var3)
		{
			for (int var4 = 0; var4 < 9; ++var4)
			{
				this.addSlotToContainer(new Slot(par1EntityPlayer.inventory, var4 + var3 * 9 + 9, 8 + var4 * 18, 85 + var3 * 18));
			}
		}

		for (var3 = 0; var3 < 9; ++var3)
		{
			this.addSlotToContainer(new Slot(par1EntityPlayer.inventory, var3, 8 + var3 * 18, 143));
		}

		this.tileEntity.getInventorys().setEventHandler(this);

	}



	@Override
	public void onCraftMatrixChanged(IInventory par1IInventory){
		this.putStackInSlot(16, ChemiCraftAPI.instance.getCraftingManager().getChemicalCombinationResult(par1IInventory));
		((InventoryChemicalCombination) par1IInventory).setFlag(true);
	}



	@Override
	public void onCraftGuiClosed(EntityPlayer par1EntityPlayer){
		super.onCraftGuiClosed(par1EntityPlayer);
	}



	@Override
	public boolean canInteractWith(EntityPlayer par1EntityPlayer){
		return this.worldObj.getBlockId(this.posX, this.posY, this.posZ) != ChemiCraft.instance.chemicalConbinationTableID ? false : par1EntityPlayer.getDistanceSq((double)this.posX + 0.5D, (double)this.posY + 0.5D, (double)this.posZ + 0.5D) <= 64.0D;
	}



	@Override
	public ItemStack transferStackInSlot(int par1){
		return null;
	}

	@Override
	public ItemStack slotClick(int par1, int par2, boolean par3, EntityPlayer par4EntityPlayer)
	{
		super.slotClick(par1, par2, par3, par4EntityPlayer);
		if(par1 == 16){
			for(int i = 0;i < 16;i++){
				if(this.inv.getStackInSlot(i) != null){
					if(this.inv.getStackInSlot(i).stackSize >= 1){
						this.putStackInSlot(i, new ItemStack(this.inv.getStackInSlot(i).itemID, --this.inv.getStackInSlot(i).stackSize, this.inv.getStackInSlot(i).getItemDamage()));
					}else{
						this.putStackInSlot(i, null);
					}
				}
			}
		}
		return null;
	}



	private void generateSlots(String activeTabs, IInventory inventorys){
		int count = 0;
		for(int i = 0;i < 4;i++){
			for(int j = 0;j < 4;j++){
				this.addSlotToContainer(new Slot(inventorys, count, 16 + 18 * j, 8 + 18 * i));
				count++;
			}
		}
		this.addSlotToContainer(new SlotChemicalCombinationResult(inventorys, count, 123, 33));
	}
}
