package chemicraft;

import net.minecraft.src.Container;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IInventory;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Slot;
import net.minecraft.src.World;

public class ContainerToolAndWeaponCraftingTable extends Container {

	/**
	 * Worldのインスタンス
	 */
	private World worldObj;


	/**
	 * BlockのX, Y, Z座標
	 */
	private int posX;
	private int posY;
	private int posZ;


	/**
	 * the TileEntity.
	 */
	private TileEntityToolAndWeaponCraftingTable tileEntity;



	public ContainerToolAndWeaponCraftingTable(EntityPlayer par1EntityPlayer, TileEntityToolAndWeaponCraftingTable par2)
	{
		super();
		this.worldObj = par2.worldObj;
		this.posX = par2.xCoord;
		this.posY = par2.yCoord;
		this.posZ = par2.zCoord;
		this.tileEntity = par2;
		//GenerateInventory
		this.generateSlots("Decomposition", par2.getInventorys());
		//GeneratePlayerInventory
		int var3;

		for (var3 = 0; var3 < 3; ++var3)
		{
			for (int var4 = 0; var4 < 9; ++var4)
			{
				this.addSlotToContainer(new Slot(par1EntityPlayer.inventory, var4 + var3 * 9 + 9, 8 + var4 * 18, 85 + var3 * 18));
			}
		}

		for (var3 = 0; var3 < 9; ++var3)
		{
			this.addSlotToContainer(new Slot(par1EntityPlayer.inventory, var3, 8 + var3 * 18, 143));
		}
	}



	@Override
	public void onCraftMatrixChanged(IInventory par1IInventory){}



	@Override
	public void onCraftGuiClosed(EntityPlayer par1EntityPlayer){
		super.onCraftGuiClosed(par1EntityPlayer);
	}



	@Override
	public boolean canInteractWith(EntityPlayer par1EntityPlayer){
		return this.worldObj.getBlockId(this.posX, this.posY, this.posZ) != ChemiCraft.instance.toolAndWeaponCraftingTableID ? false : par1EntityPlayer.getDistanceSq((double)this.posX + 0.5D, (double)this.posY + 0.5D, (double)this.posZ + 0.5D) <= 64.0D;
	}



	@Override
	public ItemStack transferStackInSlot(int par1){
		return null;
	}



	private void generateSlots(String activeTabs, IInventory[] inventorys){
		int count = 0;
		for(int i = 0;i < 3;i++){
			for(int j = 0;j < 3;j++){
				this.addSlotToContainer(new Slot(inventorys[0], count, 30 + 18 * j, 17 + 18 * i));
				count++;
			}
		}
		this.addSlotToContainer(new SlotToolAndWeaponCraftingResult(inventorys[0], count, 125, 37));
	}

}
