package chemicraft;

import java.util.List;

import net.minecraft.src.DamageSource;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityThrowable;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.PotionEffect;
import net.minecraft.src.World;

public class EntityAtomGrenade extends EntityThrowable
{

	private float explodeSize;
	private boolean isExplode;
	private boolean onFire;
	private boolean isNuke;

	public EntityAtomGrenade(World par1World, EntityLiving par2EntityLiving, boolean par3, boolean par4, boolean par5) {
		super(par1World, par2EntityLiving);
		this.isExplode = par3;
		this.onFire = par4;
		this.isNuke = par5;
	}

	@Override
	public void onUpdate(){
		super.onUpdate();
	}

	@Override
	protected void onImpact(MovingObjectPosition par1MovingObjectPosition)
	{

		if(isExplode){
			this.explodeSize = 3.0F;
		}

		if(isNuke){
			this.explodeSize = 20.0F;
		}

		if (par1MovingObjectPosition.entityHit != null) {
			par1MovingObjectPosition.entityHit.attackEntityFrom(DamageSource.causeThrownDamage(this, this.thrower), 2);
			par1MovingObjectPosition.entityHit.setFire(5);
		}

		if (!this.worldObj.isRemote && !isNuke) {
			this.worldObj.newExplosion((Entity)null, this.posX, this.posY, this.posZ, explodeSize, onFire);
			this.isDead = true;
		}else if(!this.worldObj.isRemote && isNuke){
			this.worldObj.newExplosion((Entity)null, this.posX, this.posY, this.posZ, explodeSize, onFire);
			List entity = this.worldObj.getEntitiesWithinAABB(EntityLiving.class, this.boundingBox.expand(20, 20, 20));
			for(int i = 0;i < entity.size();i++){
				((EntityLiving)entity.get(i)).addPotionEffect(new PotionEffect(18, 1, 60 * 20));
				((EntityLiving)entity.get(i)).addPotionEffect(new PotionEffect(19, 1, 60 * 20));
			}
			this.isDead = true;
		}

	}

}
