package chemicraft;

import java.io.DataOutputStream;
import java.util.ArrayList;

import com.google.common.io.ByteArrayDataInput;

import net.minecraft.src.IInventory;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagList;
import net.minecraft.src.Packet;
import net.minecraft.src.TileEntity;

public class TileEntityChemicalCombinationTable extends TileEntity {

	/**
	 * DecompositionのInventory
	 */
	public IInventory chemicalCombinationInv = new InventoryChemicalCombination();


	public TileEntityChemicalCombinationTable() {
		super();
	}

	@Override
	public void updateEntity() {
		super.updateEntity();
	}


	@Override
	public void readFromNBT(NBTTagCompound par1) {
		super.readFromNBT(par1);

		NBTTagList var2 = par1.getTagList("Items");
		for (int var3 = 0; var3 < var2.tagCount(); ++var3)
		{
			NBTTagCompound var4 = (NBTTagCompound)var2.tagAt(var3);
			int var5 = var4.getByte("Slot") & 255;

			if (var5 >= 0 && var5 < this.chemicalCombinationInv.getSizeInventory())
			{
				this.chemicalCombinationInv.setInventorySlotContents(var5, ItemStack.loadItemStackFromNBT(var4));
			}
		}
	}


	@Override
	public void writeToNBT(NBTTagCompound par1) {
		super.writeToNBT(par1);

		NBTTagList var2 = new NBTTagList();
		for (int var3 = 0; var3 < this.chemicalCombinationInv.getSizeInventory(); ++var3)
		{
			if (this.chemicalCombinationInv.getStackInSlot(var3) != null)
			{
				NBTTagCompound var4 = new NBTTagCompound();
				var4.setByte("Slot", (byte)var3);
				this.chemicalCombinationInv.getStackInSlot(var3).writeToNBT(var4);
				var2.appendTag(var4);
			}
		}
		par1.setTag("Items", var2);
	}


	public InventoryChemicalCombination getInventorys(){
		return (InventoryChemicalCombination) this.chemicalCombinationInv;
	}


	@Override
	public Packet getDescriptionPacket() {
		return PacketHandler.getPacket(this);
	}


	public void readPacket(ByteArrayDataInput data) {
		try {
		} catch (Exception e) {
			e.printStackTrace();
		}
	}


	public void writePacket(DataOutputStream dos){
		try {
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}
