package chemicraft;

import java.io.DataOutputStream;

import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IInventory;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagList;
import net.minecraft.src.Packet;
import net.minecraft.src.TileEntity;
import net.minecraft.src.WorldServer;

import com.google.common.io.ByteArrayDataInput;

import cpw.mods.fml.common.network.PacketDispatcher;

public class TileEntityDecompositionTable extends TileEntity {

	private IInventory decompositionInv = new InventoryDecomposition();

	private boolean isItemDrop = false;

	private boolean isButtonClick = false;

	private boolean isEndPutItems = false;

	public TileEntityDecompositionTable() {
		super();
	}

	@Override
	public void updateEntity() {
		super.updateEntity();
	}


	@Override
	public void readFromNBT(NBTTagCompound par1) {
		super.readFromNBT(par1);

		NBTTagList var2 = par1.getTagList("Items");
		for (int var3 = 0; var3 < var2.tagCount(); ++var3)
		{
			NBTTagCompound var4 = (NBTTagCompound)var2.tagAt(var3);
			int var5 = var4.getByte("Slot") & 255;

			if (var5 >= 0 && var5 < this.decompositionInv.getSizeInventory())
			{
				this.decompositionInv.setInventorySlotContents(var5, ItemStack.loadItemStackFromNBT(var4));
			}
		}
	}


	@Override
	public void writeToNBT(NBTTagCompound par1) {
		super.writeToNBT(par1);

		NBTTagList var2 = new NBTTagList();
		for (int var3 = 0; var3 < this.decompositionInv.getSizeInventory(); ++var3)
		{
			if (this.decompositionInv.getStackInSlot(var3) != null)
			{
				NBTTagCompound var4 = new NBTTagCompound();
				var4.setByte("Slot", (byte)var3);
				this.decompositionInv.getStackInSlot(var3).writeToNBT(var4);
				var2.appendTag(var4);
			}
		}
		par1.setTag("Items", var2);
	}


	public InventoryDecomposition getInventorys(){
		return (InventoryDecomposition) this.decompositionInv;
	}


	public void setItemDrop(boolean par1){
		this.isItemDrop = par1;
	}


	public void setButtonClick(boolean par1){
		this.isButtonClick = par1;
	}


	public void setEndPutItems(boolean par1){
		this.isEndPutItems = par1;
	}


	@Override
	public Packet getDescriptionPacket() {
		return PacketHandler.getPacket(this);
	}


	public void readPacket(ByteArrayDataInput data, EntityPlayer entityPlayer) {
		int id;
		int damage;
		int size;
		try {

			this.isItemDrop = data.readBoolean();
			this.isButtonClick = data.readBoolean();
			this.isEndPutItems = data.readBoolean();

			if(isButtonClick){
				for(int i = 0;i < this.decompositionInv.getSizeInventory();i++){
					id = data.readInt();
					damage = data.readInt();
					size = data.readInt();
					if(id != 0){
						if(i != 16){
							this.setItemDrop(entityPlayer.inventory.getFirstEmptyStack() == -1);
							if(!this.isItemDrop){
								entityPlayer.inventory.addItemStackToInventory(new ItemStack(id, size, damage));
							}else{
								entityPlayer.dropPlayerItem(new ItemStack(id, size, damage));
							}
						}
					}
				}
			}

			this.decompositionInv.setInventorySlotContents(16, null);

		} catch (Exception e) {
			e.printStackTrace();
		}
	}


	public void writePacket(DataOutputStream dos){
		try {

			dos.writeBoolean(this.isItemDrop);
			dos.writeBoolean(this.isButtonClick);
			dos.writeBoolean(this.isEndPutItems);

			for(int i = 0;i < this.decompositionInv.getSizeInventory();i++){
				if(this.decompositionInv.getStackInSlot(i) != null){
					dos.writeInt(this.decompositionInv.getStackInSlot(i).itemID);
					dos.writeInt(this.decompositionInv.getStackInSlot(i).getItemDamage());
					dos.writeInt(this.decompositionInv.getStackInSlot(i).stackSize);
				}else{
					dos.writeInt(0);
					dos.writeInt(0);
					dos.writeInt(0);
				}
			}

		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}
