package chemicraft;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;
import chemicraft.block.BlockChemicalCombinationTable;
import chemicraft.block.BlockChemicalCraftingTable;
import chemicraft.block.BlockDecompositionTable;
import chemicraft.block.BlockElectrolysisTable;
import chemicraft.block.BlockToolAndWeaponCraftingTable;
import chemicraft.compounds.CompoundWater;
import chemicraft.debug.CommandDeleteItem;
import chemicraft.debug.CommandGenDebugRoom;
import chemicraft.debug.CommandSetTile;
import chemicraft.item.ItemAtoms;
import chemicraft.item.ItemAtomsGrenade;
import chemicraft.item.ItemCompounds;
import chemicraft.item.ItemGasCollectingBottle;
import chemicraft.system.CommonProxy;
import chemicraft.system.PacketHandler;
import chemicraft.tileentity.TileEntityChemicalCombinationTable;
import chemicraft.tileentity.TileEntityChemicalCraftingTable;
import chemicraft.tileentity.TileEntityDecompositionTable;
import chemicraft.tileentity.TileEntityElectrolysisTable;
import chemicraft.tileentity.TileEntityToolAndWeaponCraftingTable;
import chemicraft.util.Auxiliary;
import chemicraft.util.Auxiliary.ArrayAuxiliary;
import chemicraft.util.Auxiliary.NameAuxiliary;
import chemicraft.util.CreativeTabAtoms;
import chemicraft.util.NBTRecipeGrenade;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;

/**
 * ChemiCraft本体
 * @author P.C.C.
 *
 */
@Mod(modid = "chemiCraft", name = "ChemiCraft", version = "beta")
// ID,名前,バージョン
@NetworkMod(clientSideRequired = true, serverSideRequired = true, versionBounds = "1.4.6", channels = "chemicraft", packetHandler = PacketHandler.class)
// クライアント、サーバー共に必要 1.3.2用
public class ChemiCraft {

	public static final String[] ATOMSNAME = {
		"Hydrogen", "Helium", "Lithium", "Beryllium", "Boron", "Carbon", "Nitrogen", "Oxygen", "Fluorine", "Neon", "Sodium", "Magnesium", "Aluminium", "Silicon",
		"Phosphorus", "Sulfur", "Chlorine", "Argon", "Potassium", "Calcium", "Scandium", "Titanium", "Vanadium", "Chromium", "Manganese", "Iron", "Cobalt", "Nickel", "Copper", "Zinc", "Gallium",
		"Germanium", "Arsenic", "Selenium", "Bromine", "Krypton", "Rubidium", "Strontium", "Yttorium", "Zirconium", "Niobium", "Molybdenum", "Technetium", "Ruthenium", "Rhodium", "Palladium",
		"Silver", "Cadmium", "Indium", "Tin", "Antimony", "Tellurium", "Iodine", "Xenon", "Caesium", "Barium", "Lanthanum", "Cerium", "Praseodymium", "Neodymium", "Promethium", "Samarium",
		"Europium", "Gadolinium", "Terbium", "Dysprosium", "Holmium", "Erbium", "Thulium", "Ytterbium", "Lutetium", "Hafnium", "Tantalum", "Tungsten", "Rhenium", "Osmium", "Iridium", "Platinum",
		"Gold", "Mercury", "Thallium", "Lead", "Bismuth", "Polonium", "Astatine", "Radon", "Francium", "Radium", "Actinium", "Thorium", "Protactinium", "Uranium", "Neptunium", "Plutonium",
		"Americium", "Curium", "Berkelium", "Californium", "Einsteinium", "Fermium", "Mendelevium", "Nobelium", "Lawrencium", "Rutherfordium", "Dubnium", "Seaborgium", "Bohrium", "Hassium",
		"Meitnerium", "Darmstadtium", "Roentgenium", "Copernicium", "Ununtrium", "Ununquadium", "Ununpentium", "Ununhexium", "Ununseptium", "Ununoctium" };

	public static final String[] ATOMSNAMEJP = {
		"水素", "ヘリウム", "リチウム", "ベリウム", "ホウ素", "炭素", "窒素", "酸素", "フッ素", "ネオン", "ナトリウム", "マグネシウム", "アルミニウム", "ケイ素", "リン", "硫黄", "塩素", "アルゴン", "カリウム", "カルシウム", "スカンジウム",
		"チタン", "バナジウム", "クロム", "マンガン", "鉄", "コバルト", "ニッケル", "銅", "亜鉛", "ガリウム", "ゲルマニウム", "ヒ素", "セレン", "臭素", "クリプトン", "ルビジウム", "ストロンチウム", "イットリウム", "ジルコニウム", "ニオブ", "モリブデン", "テクネチウム", "ルテニウム",
		"ロジウム", "パラジウム", "銀", "カドミウム", "インジウム", "スズ", "アンチモン", "テルル", "ヨウ素", "キセノン", "セシウム", "バリウム", "ランタン", "セリウム", "プラセオジム", "ネオジム", "プロメチウム", "サマリウム", "ユウロビウム", "ガドリニウム", "テルビウム", "ジスプロニウム",
		"ホルミウム", "エルビウム", "ツリウム", "イッテルビウム", "ルテチウム", "ハフニウム", "タンタル", "タングステン", "レニウム", "オスミウム", "イリジウム", "白金", "金", "水銀", "タリウム", "鉛", "ビスマス", "ポロニウム", "アスタチン", "ラドン", "フランシウム", "ラジウム",
		"アクチニウム", "トリウム", "プロトアクチウム", "ウラン", "ネプツニウム", "プルトニウム", "アメリシウム", "キュリウム", "バークリウム", "カルホルニウム", "アインスタイニウム", "フェルミウム", "メンデレビウム", "ノーベリウム", "ローレンシウム", "ラサホージウム", "ドブニウム", "シーボーギウム",
		"ボーリウム", "ハッシウム", "マイトネリウム", "ダームスタチウム", "レントゲニウム", "コペルニシウム", "ウンウントリウム", "ウンウンクアジウム", "ウンウンペンチウム", "ウンウンヘキシウム", "ウンウンセプチウム", "ウンウンオクチウム" };

	/**
	 * このmodのインスタンス
	 */
	@Mod.Instance("chemiCraft")
	public static ChemiCraft instance;

	/**
	 * ChemiCraftのProxy.
	 */
	@SidedProxy(clientSide = "chemicraft.client.ClientProxy", serverSide = "chemicraft.system.CommonProxy")
	public static CommonProxy proxy;

	/**
	 * ChemiCraftのCreativeTab.
	 */
	public static final CreativeTabs creativeTab = new CreativeTabAtoms("ChemiCraft");

	/**
	 * ItemID.
	 */
	public int atomsID;
	public int compoundsID;
	public int gasCollectingBottleID;
	public int atomGrenadeID;

	/**
	 * BlockID.
	 */
	public int decompositionTableID;
	public int chemicalConbinationTableID;
	public int toolAndWeaponCraftingTableID;
	public int chemicalCraftingTableID;
	public int electrolysisTableID;

	/**
	 * GUIID.
	 */
	public int guiDecompositionTableID;
	public int guiChemicalCombinationTableID;
	public int guiToolAndWeaponCraftingTableID;
	public int guiChemicalCraftingTableID;
	public int guiElectrolysisTableID;

	/**
	 * Block型変数.
	 */
	public Block blockDecompositionTable;
	public Block blockChemicalCombinationTable;
	public Block blockToolAndWeaponCraftingTable;
	public Block blockChemicalCraftingTable;
	public Block blockElectrolysisTable;

	/**
	 * Item型変数.
	 */
	public Item itemAtoms;
	public Item itemCompounds;
	public Item itemGasCollectingBottle;
	public Item itemAtomGrenade;

	/**
	 * このmodで使用するTextureのパス.
	 */
	public String itemAtomsTexture = "/chemicraft/items/Atoms.png";
	public String itemCompoundsTexture = "/chemicraft/items/Compounds.png";
	public String itemTexture = "/chemicraft/items/items.png";
	public String blockChemicalCraftingTableTexture = "/chemicraft/blocks/CCTable.png";
	public String guiDecompositionTexture = "/chemicraft/guis/Decomposition.png";
	public String guiChemicalCombinationTexture = "/chemicraft/guis/ChemicalCombination.png";
	public String guiToolAndWeaponCraftingTexture = "/chemicraft/guis/ToolAndWeaponCrafting.png";
	public String guiChemicalCraftingTexture = "/chemicraft/guis/MaterialCrafting.png";
	public String guiElectrolysisTableTexture = "/chemicraft/guis/ElectrolysisTable.png";

	/**
	 * このmodに必要な補助クラスのインスタンス.
	 */
	public Auxiliary auxiliary = new Auxiliary();
	public NameAuxiliary nameAuxiliary = new NameAuxiliary();
	public ArrayAuxiliary arrayAuxiliary = new ArrayAuxiliary();

	private ChemiCraftAPI api = ChemiCraftAPI.getInstance();
	private ChemiCraftData chemicalData = new ChemiCraftData();

	@Mod.PreInit
	public void chemiPreLoadMethod(final FMLPreInitializationEvent event) {
		Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
		cfg.load();

		Property decompositionTableIDProp = cfg.getBlock("DecompositionTable", 2400);
		Property chemicalCombinationTableIDProp = cfg.getBlock("ChemicalCombinationID", 2401);
		Property toolAndWeaponCraftingTableIDProp = cfg.getBlock("ToolAndWeaponCraftingTableID", 2402);
		Property chemicalCraftingTableIDProp = cfg.getBlock("ChemicalCraftingTableID", 2403);
		Property electrolysisTableIDProp = cfg.getBlock("ElectrolysisTableID", 2404);

		Property atomsIDProp = cfg.getItem("AtomsID", 25000);
		Property compoundsIDProp = cfg.getItem("CompoundsID", 25001);
		Property gasCollectingBottleIDProp = cfg.getItem("gasCollectingBottleID", 25002);
		Property atomGrenadeIDProp = cfg.getItem("AtomGrenadeID", 25003);

		Property guiDecompositionTableIDProp = cfg.get("GUI", "GUIChemicalCraftingTableID", 1000);
		Property guiChemicalCombinationTableIDProp = cfg.get("GUI", "GUIChemicalCombinationTableID", 1001);
		Property guiToolAndWeaponCraftingTableIDProp = cfg.get("GUI", "GUIToolAndWeaponCraftingTableID", 1002);
		Property guiChemicalCraftingTableIDProp = cfg.get("GUI", "GUIChemicalCraftingTableID", 1003);
		Property guiElectrolysisTableIDProp = cfg.get("GUI", "GUIElectrolysisTableID", 1004);


		this.decompositionTableID = decompositionTableIDProp.getInt();
		this.chemicalConbinationTableID = chemicalCombinationTableIDProp.getInt();
		this.toolAndWeaponCraftingTableID = toolAndWeaponCraftingTableIDProp.getInt();
		this.chemicalCraftingTableID = chemicalCraftingTableIDProp.getInt();
		this.electrolysisTableID = electrolysisTableIDProp.getInt();
		this.atomsID = atomsIDProp.getInt();
		this.compoundsID = compoundsIDProp.getInt();
		this.gasCollectingBottleID = gasCollectingBottleIDProp.getInt();
		this.atomGrenadeID = atomGrenadeIDProp.getInt();
		this.guiDecompositionTableID = guiDecompositionTableIDProp.getInt();
		this.guiChemicalCombinationTableID = guiChemicalCombinationTableIDProp.getInt();
		this.guiToolAndWeaponCraftingTableID = guiToolAndWeaponCraftingTableIDProp.getInt();
		this.guiChemicalCraftingTableID = guiChemicalCraftingTableIDProp.getInt();
		this.guiElectrolysisTableID = guiElectrolysisTableIDProp.getInt();

		cfg.save();
	}

	@Mod.ServerStarting
	public void serverStarting(final FMLServerStartingEvent event) {
		event.registerServerCommand(new CommandSetTile());
		event.registerServerCommand(new CommandDeleteItem());
		event.registerServerCommand(new CommandGenDebugRoom());
	}

	@Mod.PostInit
	public void chemiPostLoadMethod(final FMLPostInitializationEvent event) {
		this.settingProcessing(event);
		this.apiProcessing(event);
		this.debug(event);
	}

	private void settingProcessing(final FMLPostInitializationEvent event) {

		// Blockを追加します
		this.blockDecompositionTable = new BlockDecompositionTable(this.decompositionTableID, 0, Material.ground).
				setHardness(2.0F).
				setResistance(0.0F).
				setStepSound(Block.soundStoneFootstep).
				setBlockName("DecompositionTable");
		this.blockChemicalCombinationTable = new BlockChemicalCombinationTable(this.chemicalConbinationTableID, 0, Material.ground).
				setHardness(2.0F).
				setResistance(0.0F).
				setStepSound(Block.soundStoneFootstep).
				setBlockName("ChemicalCombinationTable");
		this.blockToolAndWeaponCraftingTable = new BlockToolAndWeaponCraftingTable(this.toolAndWeaponCraftingTableID, 0, Material.ground).
				setHardness(2.0F).
				setResistance(0.0F).
				setStepSound(Block.soundStoneFootstep).
				setBlockName("ToolAndWeaponCraftingTable");
		this.blockChemicalCraftingTable = new BlockChemicalCraftingTable(chemicalCraftingTableID, 0, Material.ground).
				setHardness(2.0F).
				setResistance(0.0F).
				setStepSound(Block.soundStoneFootstep).
				setBlockName("ChemicalCraftingTable");
		this.blockElectrolysisTable = new BlockElectrolysisTable(electrolysisTableID, 0, Material.ground).
				setHardness(2.0F).
				setResistance(0.0F).
				setStepSound(Block.soundStoneFootstep).
				setBlockName("ElectrolysisTable");

		// Itemを追加します
		this.itemAtoms = new ItemAtoms(this.atomsID).setItemName("atoms");
		this.itemCompounds = new ItemCompounds(this.compoundsID).setItemName("compounds");
		this.itemGasCollectingBottle = new ItemGasCollectingBottle(this.gasCollectingBottleID).setItemName("gasCollectingBottle").setIconIndex(0);
		this.itemAtomGrenade = new ItemAtomsGrenade(this.atomGrenadeID).setItemName("grenade").setIconIndex(1);

		// BlockをMinecraftに登録します
		GameRegistry.registerBlock(this.blockDecompositionTable, "BlockDecompositionTable");
		GameRegistry.registerBlock(this.blockChemicalCombinationTable, "BlockChemicalCombinationTable");
		GameRegistry.registerBlock(this.blockToolAndWeaponCraftingTable, "BlockToolAndWeaponCraftingTable");
		GameRegistry.registerBlock(this.blockChemicalCraftingTable, "BlockMaterialCraftingTable");
		GameRegistry.registerBlock(this.blockElectrolysisTable, "ElectrolysisTable");

		// Blockの名前を設定します
		this.nameAuxiliary.addName(this.blockDecompositionTable, "DecompositionTable");
		this.nameAuxiliary.addName(this.blockDecompositionTable, "ja_JP", "分解台");
		this.nameAuxiliary.addName(this.blockChemicalCombinationTable, "ChemicalCombinationTable");
		this.nameAuxiliary.addName(this.blockChemicalCombinationTable, "ja_JP", "化合台");
		this.nameAuxiliary.addName(blockToolAndWeaponCraftingTable, "ToolAndWeaponCraftingTable");
		this.nameAuxiliary.addName(blockToolAndWeaponCraftingTable, "ja_JP", "ツール&武器製作台");
		this.nameAuxiliary.addName(blockChemicalCraftingTable, "ChemicalCraftingTable");
		this.nameAuxiliary.addName(blockChemicalCraftingTable, "ja_JP", "素材製作台");
		this.nameAuxiliary.addName(this.blockElectrolysisTable, "ElectrolysisTable");
		this.nameAuxiliary.addName(this.blockElectrolysisTable, "ja_JP", "電気分解台");

		// Itemの名前を設定します
		this.nameAuxiliary.addName(this.itemAtoms, ATOMSNAME);
		this.nameAuxiliary.addName(this.itemAtoms, "ja_JP", ATOMSNAMEJP);
		this.nameAuxiliary.addName(this.itemGasCollectingBottle, "GasCollectingBottle");
		this.nameAuxiliary.addName(this.itemGasCollectingBottle, "ja_JP", "集気瓶");
		this.nameAuxiliary.addName(this.itemAtomGrenade, "AtomGrenade");
		this.nameAuxiliary.addName(this.itemAtomGrenade, "元素手榴弾");

		// TileEntityを追加します
		GameRegistry.registerTileEntity(TileEntityDecompositionTable.class, "DecompositionTable");
		GameRegistry.registerTileEntity(TileEntityChemicalCombinationTable.class, "TileEntityChemicalCombinationTable");
		GameRegistry.registerTileEntity(TileEntityToolAndWeaponCraftingTable.class, "TileEntityToolAndWeaponCraftingTable");
		GameRegistry.registerTileEntity(TileEntityChemicalCraftingTable.class, "TileEntityChemicalCraftingTable");
		GameRegistry.registerTileEntity(TileEntityElectrolysisTable.class, "TileEntityElectrolysisTable");

		// GUIを追加します
		NetworkRegistry.instance().registerGuiHandler(instance, proxy);

		// 描画関係の読み込み
		proxy.registerRenderInformation();

		//化学作業台類のレシピを追加します
		GameRegistry.addRecipe(new ItemStack(this.blockDecompositionTable),
				new Object[]{
			"XYX", "ZAZ", "ZZZ",
			Character.valueOf('X'), new ItemStack(Item.ingotIron),
			Character.valueOf('Y'), new ItemStack(Block.workbench),
			Character.valueOf('Z'), new ItemStack(Block.stone),
			Character.valueOf('A'), new ItemStack(Block.tnt),
		});
		GameRegistry.addRecipe(new ItemStack(this.blockChemicalCombinationTable),
				new Object[]{
			"XYX", "ZAZ", "ZZZ",
			Character.valueOf('X'), new ItemStack(Item.ingotIron),
			Character.valueOf('Y'), new ItemStack(Block.workbench),
			Character.valueOf('Z'), new ItemStack(Block.stone),
			Character.valueOf('A'), new ItemStack(Block.obsidian),
		});
		GameRegistry.addRecipe(new ItemStack(this.blockToolAndWeaponCraftingTable),
				new Object[]{
			"XYX", "ZAZ", "ZZZ",
			Character.valueOf('X'), new ItemStack(Item.ingotIron),
			Character.valueOf('Y'), new ItemStack(Block.workbench),
			Character.valueOf('Z'), new ItemStack(Block.stone),
			Character.valueOf('A'), new ItemStack(Item.pickaxeSteel),
		});
		GameRegistry.addRecipe(new ItemStack(this.blockChemicalCraftingTable),
				new Object[]{
			"XYX", "ZAZ", "ZZZ",
			Character.valueOf('X'), new ItemStack(Item.ingotIron),
			Character.valueOf('Y'), new ItemStack(Block.workbench),
			Character.valueOf('Z'), new ItemStack(Block.stone),
			Character.valueOf('A'), new ItemStack(this.itemAtoms, 1, 0),
		});

		// 化合物を追加します
		api.addLangCompound("ja_JP", "CarbonMonoxide", "一酸化炭素");
		api.addLangCompound("ja_JP", "CarbonDioxide", "二酸化炭素");
		api.addLangCompound("ja_JP", "Water", "水");
		api.addCompound("Test");


		//化合物のHandlerを設定します
		api.settingCompoundHandler("Water", new CompoundWater());

		//化合物のレシピを追加します
		api.addChemicalCombinationRecipe(new String[]{"C", "O"}, new Integer[]{1, 2}, new ItemStack(this.itemCompounds, 1, api.getCompound("CarbonDioxide")));
		api.addChemicalCombinationRecipe(new String[]{"H", "O"}, new Integer[]{2, 1}, new ItemStack(this.itemCompounds, 1, api.getCompound("Water")));

		//手榴弾の追加
		api.addMaterialRecipe(
				new ItemStack[]{
						null,
						new ItemStack(Block.stone),
						null,
						new ItemStack(Block.stone),
						new ItemStack(Item.gunpowder),
						new ItemStack(Block.stone),
						null,
						new ItemStack(Block.stone),
						null
				},
				new ItemStack(this.itemAtomGrenade, 16, 0),
				new NBTRecipeGrenade()
				);
	}

	private void apiProcessing(final FMLPostInitializationEvent event) {
		// API用の処理
		this.nameAuxiliary.addName(itemCompounds, api.getInstance().getCompoundsName().toArray());
		for (int i = 0; i < api.getCompoundsLang().size(); i++) {
			this.nameAuxiliary.addName(itemCompounds, api.getCompoundsLang().get(i), api.getInstance().getCompoundsLangName().toArray());
		}
	}

	private void debug(final FMLPostInitializationEvent event) {
	}

}