package chemicraft;

import java.util.ArrayList;
import java.util.HashMap;

import net.minecraft.item.ItemStack;
import chemicraft.system.ChemiCraftCraftingManager;
import chemicraft.util.ChemicalNBTRecipe;
import chemicraft.util.ICompoundHandler;
import chemicraft.util.MaterialRecipe;

/**
 * ChemiCraftのAPI
 * 基本的にAddonはこのクラスのインスタンスを使う
 * @author mozipi
 *
 */
public class ChemiCraftAPI {

	/**
	 * Instance of the ChemiCraftAPI.
	 */
	private static ChemiCraftAPI instance = new ChemiCraftAPI();


	/**
	 * List of compounds names.
	 */
	private ArrayList<String> compoundsNameList = new ArrayList<String>();


	/**
	 * List of compounds names(Some kind of language).
	 */
	private ArrayList<String> compoundsLangNameList = new ArrayList<String>();


	/**
	 * List of compounds the language names.
	 */
	private ArrayList<String> compoundsLangList = new ArrayList<String>();


	/**
	 * List of compounds handlers.
	 */
	private ArrayList<ICompoundHandler> compoundHandlers = new ArrayList<ICompoundHandler>();


	/**
	 * 化合物の文字列をダメージ値に変換します。
	 */
	private HashMap<String, Integer> compoundHash = new HashMap<String, Integer>();


	/**
	 * List of item name of handler to compounds.
	 */
	private ArrayList<String> compoundHandlerItemNames = new ArrayList<String>();


	/**
	 * 分解台の素材のリスト
	 */
	private ArrayList<ItemStack> decompositionMaterial = new ArrayList<ItemStack>();


	/**
	 * 分解台の結果のリスト
	 */
	private ArrayList<ItemStack[]> decompositionResults = new ArrayList<ItemStack[]>();


	/**
	 * 化合台の原子の種類のリスト
	 */
	private ArrayList<String[]> chemicalCombinationAtoms = new ArrayList<String[]>();


	/**
	 * 化合台の原子の数のリスト
	 */
	private ArrayList<Integer[]> chemicalCombinationAmounts = new ArrayList<Integer[]>();


	/**
	 * 化合台の結果のリスト
	 */
	private ArrayList<ItemStack> chemicalCombinationResult = new ArrayList<ItemStack>();


	/**
	 * 素材製作台のレシピクラス
	 */
	private ArrayList<MaterialRecipe> materialRecipe = new ArrayList<MaterialRecipe>();


	/**
	 * ChemiCraftの化学作業台類のレシピのマネージャー
	 */
	private ChemiCraftCraftingManager chemiCraftCraftingManager = new ChemiCraftCraftingManager();



	/**
	 * add compound.
	 * @param name compound name.
	 */
	public void addCompound(String name){
		addLangCompound("", name, "");
	}



	/**
	 * add compound corresponding to the language.
	 * @param lang Language to the corresponding
	 * @param englishName compound name
	 * @param langName compound name(specified language)
	 */
	public void addLangCompound(String lang, String englishName, String langName){
		compoundsNameList.add(englishName);
		compoundsLangNameList.add(langName);
		compoundsLangList.add(lang);
		compoundHash.put(englishName, compoundHash.size());
	}



	public int getCompound(String key){
		if(compoundHash.get(key) != null){
			return compoundHash.get(key);
		} else {
			return -1;
		}
	}



	/**
	 * setting compound handler.
	 * @param handlerItemName
	 * @param compoundHandler
	 */
	public void settingCompoundHandler(String handlerItemName, ICompoundHandler compoundHandler){
		compoundHandlers.add(compoundHandler);
		compoundHandlerItemNames.add(handlerItemName);
	}



	/**
	 * 分解レシピを追加します。resultの要素数は0<= n <= 16にしてください。
	 * @param material 素材
	 * @param result 結果
	 */
	public void addDecompositionRecipe(ItemStack material, ItemStack[] result){
		if(result.length <= 16){
			decompositionMaterial.add(material);
			decompositionResults.add(result);
		}else{
			System.err.println("ChemiCraft内でエラー:addDecompositionRecipeの引数resultの要素数が16を超えています。" + "Material:" + material + "  Result:" + result);
		}
	}



	/**
	 * 化合レシピを追加します。materialの要素数は0<= n <= 16にしてください。
	 * @param material 素材
	 * @param result 結果
	 */
	public void addChemicalCombinationRecipe(String[] atoms, Integer[] amounts, ItemStack result){
		chemicalCombinationAtoms.add(atoms);
		chemicalCombinationAmounts.add(amounts);
		chemicalCombinationResult.add(result);
	}



	public void addSharplessMaterialRecipe(ItemStack[] materials, ItemStack result, ChemicalNBTRecipe nbtRecipe){
		materialRecipe.add(new MaterialRecipe(result, materials, nbtRecipe, true));
	}

	public void addMaterialRecipe(ItemStack[] materials, ItemStack result, ChemicalNBTRecipe nbtRecipe){
		materialRecipe.add(new MaterialRecipe(result, materials, nbtRecipe, false));
	}
	//以下システム関連//////////////////////////////////////////////////////

	public ArrayList<ICompoundHandler> getCompoundHandler(){
		compoundHandlers.trimToSize();
		return compoundHandlers;

	}



	public ArrayList<String> getCompoundHandlerItemName(){
		compoundHandlerItemNames.trimToSize();
		return compoundHandlerItemNames;
	}



	public ArrayList<String> getCompoundsName(){
		compoundsNameList.trimToSize();
		return compoundsNameList;
	}



	public ArrayList<String> getCompoundsLangName(){
		compoundsLangNameList.trimToSize();
		return compoundsLangNameList;
	}



	public ArrayList<String> getCompoundsLang(){
		compoundsLangList.trimToSize();
		return compoundsLangList;
	}



	public ArrayList<ItemStack> getDecompositionMaterial(){
		return decompositionMaterial;
	}



	public ArrayList<ItemStack[]> getDecompositionResult(){
		return decompositionResults;
	}



	public ArrayList<String[]> getChemicalCombinationAtoms(){
		return chemicalCombinationAtoms;
	}



	public ArrayList<Integer[]> getChemicalCombinationAmounts(){
		return chemicalCombinationAmounts;
	}



	public ArrayList<ItemStack> getChemicalCombinationResult(){
		return chemicalCombinationResult;
	}



	public ArrayList<MaterialRecipe> getMaterialRecipe(){
		return materialRecipe;
	}



	public ChemiCraftCraftingManager getCraftingManager(){
		return chemiCraftCraftingManager;
	}



	public static ChemiCraftAPI getInstance(){
		return instance;
	}

}
