package chemicraft.client;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import chemicraft.ChemiCraft;
import chemicraft.entity.EntityAtomsGrenade;
import chemicraft.gui.GuiChemicalCombinationTable;
import chemicraft.gui.GuiChemicalCraftingTable;
import chemicraft.gui.GuiDecompositionTable;
import chemicraft.gui.GuiElectrolysisTable;
import chemicraft.gui.GuiToolAndWeaponCraftingTable;
import chemicraft.render.RenderAtomsGrenade;
import chemicraft.system.CommonProxy;
import chemicraft.tileentity.TileEntityChemicalCombinationTable;
import chemicraft.tileentity.TileEntityChemicalCraftingTable;
import chemicraft.tileentity.TileEntityDecompositionTable;
import chemicraft.tileentity.TileEntityElectrolysisTable;
import chemicraft.tileentity.TileEntityToolAndWeaponCraftingTable;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;

public class ClientProxy extends CommonProxy {

	@Override
	public void registerRenderInformation() {
		MinecraftForgeClient.preloadTexture(ChemiCraft.instance.blockChemicalCraftingTableTexture);
		MinecraftForgeClient.preloadTexture(ChemiCraft.instance.itemAtomsTexture);
		MinecraftForgeClient.preloadTexture(ChemiCraft.instance.itemCompoundsTexture);
		MinecraftForgeClient.preloadTexture(ChemiCraft.instance.itemTexture);
		MinecraftForgeClient.preloadTexture(ChemiCraft.instance.guiChemicalCombinationTexture);
		MinecraftForgeClient.preloadTexture(ChemiCraft.instance.guiDecompositionTexture);
		MinecraftForgeClient.preloadTexture(ChemiCraft.instance.guiChemicalCraftingTexture);
		MinecraftForgeClient.preloadTexture(ChemiCraft.instance.guiToolAndWeaponCraftingTexture);
		MinecraftForgeClient.preloadTexture(ChemiCraft.instance.guiElectrolysisTableTexture);
		RenderingRegistry.registerEntityRenderingHandler(EntityAtomsGrenade.class, new RenderAtomsGrenade(0.5F));
	}


	@Override
	public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
		if (!world.blockExists(x, y, z))
			return null;

		TileEntity tileEntity = world.getBlockTileEntity(x, y, z);
		if (tileEntity instanceof TileEntityDecompositionTable) {
			return new GuiDecompositionTable(player, (TileEntityDecompositionTable) tileEntity);
		}else if(tileEntity instanceof TileEntityChemicalCombinationTable){
			return new GuiChemicalCombinationTable(player, (TileEntityChemicalCombinationTable) tileEntity);
		}else if(tileEntity instanceof TileEntityToolAndWeaponCraftingTable){
			return new GuiToolAndWeaponCraftingTable(player, (TileEntityToolAndWeaponCraftingTable) tileEntity);
		}else if(tileEntity instanceof TileEntityChemicalCraftingTable){
			return new GuiChemicalCraftingTable(player, (TileEntityChemicalCraftingTable) tileEntity);
		}else if(tileEntity instanceof TileEntityElectrolysisTable){
			return new GuiElectrolysisTable(player, (TileEntityElectrolysisTable) tileEntity);
		}
		return null;
	}


	@Override
	public World getClientWorld() {
		return FMLClientHandler.instance().getClient().theWorld;
	}

}
