package chemicraft.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.world.World;
import chemicraft.ChemiCraft;
import chemicraft.tileentity.TileEntityDecompositionTable;

public class ContainerDecompositionTable extends Container {

	private World worldObj;

	private int posX;
	private int posY;
	private int posZ;

	public ContainerDecompositionTable(EntityPlayer par1EntityPlayer, TileEntityDecompositionTable par2){
		super();
		this.worldObj = par2.worldObj;
		this.posX = par2.xCoord;
		this.posY = par2.yCoord;
		this.posZ = par2.zCoord;
	}

	@Override
	public boolean canInteractWith(EntityPlayer par1EntityPlayer) {
		return this.worldObj.getBlockId(this.posX, this.posY, this.posZ) != ChemiCraft.instance.decompositionTableID ? false : par1EntityPlayer.getDistanceSq((double)this.posX + 0.5D, (double)this.posY + 0.5D, (double)this.posZ + 0.5D) <= 64.0D;
	}

}
