package chemicraft.item;

import java.util.List;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import chemicraft.ChemiCraft;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class ItemAtoms extends Item {

	public ItemAtoms(int par1){
		super(par1);
		this.maxStackSize = 64;
		this.setHasSubtypes(true);
		this.setMaxDamage(0);
		this.setCreativeTab(ChemiCraft.instance.creativeTab);
	}



	@SuppressWarnings({ "unchecked", "rawtypes" })
	@SideOnly(Side.CLIENT)
	@Override
	public void getSubItems(int par1, CreativeTabs par2CreativeTabs, List par3List){
		for(int type = 0; type < ChemiCraft.instance.ATOMSNAME.length; type++)
		{
			par3List.add(new ItemStack(par1, 1, type));
			this.setIconIndex(type);
		}
	}



	@Override
	public String getItemNameIS(ItemStack par1ItemStack){
		return super.getItemName() + "." + ChemiCraft.instance.ATOMSNAME[par1ItemStack.getItemDamage()];
	}



	@Override
	public String getTextureFile(){
		return ChemiCraft.instance.itemAtomsTexture;
	}



	@SideOnly(Side.CLIENT)
	@Override
	public int getIconFromDamage(int par1){
		return par1;
	}

}