package chemicraft.item;

import java.util.List;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import chemicraft.ChemiCraft;
import chemicraft.ChemiCraftAPI;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class ItemCompounds extends Item {

	public ItemCompounds(int par1){
		super(par1);
		this.setHasSubtypes(true);
		this.setMaxDamage(0);
		this.setCreativeTab(ChemiCraft.instance.creativeTab);
	}

	@Override
	public boolean onItemUse(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7, float par8, float par9, float par10) {
		for(int i=0;i < ChemiCraftAPI.getInstance().getCompoundHandlerItemName().size();i++){
			if(ChemiCraftAPI.getInstance().getCompoundsName().get(par1ItemStack.getItemDamage()).equals(ChemiCraftAPI.getInstance().getCompoundHandlerItemName().get(i))){
				return ChemiCraftAPI.getInstance().getCompoundHandler().get(i).onItemUseHandler(par1ItemStack, par2EntityPlayer, par3World, par4, par5, par6, par7, par8, par9, par10);
			}
		}
		return false;
	}


	@Override
	public ItemStack onItemRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer)
	{
		for(int i=0;i < ChemiCraftAPI.getInstance().getCompoundHandlerItemName().size();i++){
			if(ChemiCraftAPI.getInstance().getCompoundsName().get(par1ItemStack.getItemDamage()).equals(ChemiCraftAPI.getInstance().getCompoundHandlerItemName().get(i))){
				ChemiCraftAPI.getInstance().getCompoundHandler().get(i).onItemRightClickHandler(par1ItemStack, par2World, par3EntityPlayer);
			}
		}
		return par1ItemStack;
	}



	@Override
	public void onUpdate(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5){
		for(int i=0;i < ChemiCraftAPI.getInstance().getCompoundHandlerItemName().size();i++){
			if(ChemiCraftAPI.getInstance().getCompoundsName().get(par1ItemStack.getItemDamage()).equals(ChemiCraftAPI.getInstance().getCompoundHandlerItemName().get(i))){
				ChemiCraftAPI.getInstance().getCompoundHandler().get(i).onUpdateHandler(par1ItemStack, par2World, par3Entity, par4, par5);
			}
		}
	}



	@SuppressWarnings({ "unchecked", "rawtypes" })
	@SideOnly(Side.CLIENT)
	@Override
	public void getSubItems(int par1, CreativeTabs par2CreativeTabs, List par3List){
		for(int type = 0; type < ChemiCraftAPI.getInstance().getCompoundsName().toArray().length; type++)
		{
			par3List.add(new ItemStack(par1, 1, type));
			this.setIconIndex(type);
		}
	}



	@Override
	public String getItemNameIS(ItemStack par1ItemStack){
		return super.getItemName() + "." + ChemiCraftAPI.getInstance().getCompoundsName().toArray()[par1ItemStack.getItemDamage()];
	}



	@Override
	public String getTextureFile(){
		return ChemiCraft.instance.itemCompoundsTexture;
	}



	@SideOnly(Side.CLIENT)
	@Override
	public int getIconFromDamage(int par1){
		for(int i=0;i < ChemiCraftAPI.getInstance().getCompoundHandlerItemName().size();i++){
			if(ChemiCraftAPI.getInstance().getCompoundsName().get(par1).equals(ChemiCraftAPI.getInstance().getCompoundHandlerItemName().get(i))){
				return ChemiCraftAPI.getInstance().getCompoundHandler().get(i).getIconIndexHandler();
			}
		}
		return 0;
	}

}
