package pcc.chemicraft.base;

import java.util.ArrayList;
import java.util.HashMap;

import pcc.chemicraft.base.gen.EnumOreSpawnFrequency;
import pcc.chemicraft.base.gen.WorldGenAtomsOre;
import pcc.chemicraft.util.AtomInfo;
import pcc.chemicraft.util.Formula;
import pcc.chemicraft.util.ListHash;

public class ChemiCraftBaseAPI
{

	private static ChemiCraftBaseAPI instance = new ChemiCraftBaseAPI();


	public static ChemiCraftBaseAPI instance(){
		return instance;
	}

	/**
	 * 鉱石別元素数リスト
	 */
	private HashMap<String, Formula> atomOresFormulasHash = new HashMap<String, Formula>();


	/**
	 * 鉱石の言語リスト
	 */
	private ListHash<String, String> atomOresLangListHash = new ListHash<String, String>();


	/**
	 * 鉱石リスト
	 */
	private ArrayList<WorldGenAtomsOre> atomOresList = new ArrayList<WorldGenAtomsOre>();


	/**
	 * 鉱石名リスト
	 */
	private ListHash<String, String> atomOresNameListHash = new ListHash<String, String>();



	/**
	 * 鉱石を追加します。
	 * @param par1Name
	 * @param par2Formula
	 * @param par3Id
	 * @param par4Size
	 * @param par5Frequency
	 * @param par6PosY
	 */
	public void addAtomOres(String par1Name, Formula par2Formula, int par3Id, int par4Size, int par5Frequency, int par6PosY){
		atomOresList.add(
				new WorldGenAtomsOre(
						par3Id,
						getAtomOresMetaOfLastIndex(),
						par4Size,
						par5Frequency,
						par6PosY));
		atomOresFormulasHash.put(par1Name, par2Formula);

		String var7 = par1Name;
		if (!var7.contains(" Ore")){
			var7 = var7.concat(" Ore");
		}
		addAtomOresLanguage(par1Name, var7, "en_US");
	}



	public void addAtomOres(String par1Name, Formula par2Formula, int par3Id, EnumOreSpawnFrequency par4Enum){
		addAtomOres(
				par1Name,
				par2Formula,
				par3Id,
				par4Enum.getSize(),
				par4Enum.getFrequency(),
				par4Enum.getPosY()
				);
	}



	/**
	 * 既に登録した鉱石の新しい名前・言語を追加します
	 * @param par1Name 英語名
	 * @param par2NewName 新しい名前
	 * @param par3Language 言語
	 */
	public void addAtomOresLanguage(String par1Name, String par2NewName, String par3Language){
		atomOresNameListHash.add(par1Name,
				par2NewName);
		atomOresLangListHash.add(par1Name,
				par3Language);
	}



	//以下システム関連//////////////////////////////////////////////////////

	public ArrayList<WorldGenAtomsOre> getAtomOres(){
		return atomOresList;
	}

	public HashMap<String, Formula> getAtomOresFormulas(){
		return atomOresFormulasHash;
	}



	public ListHash<String, String> getAtomOresLanguage(){
		return atomOresLangListHash;
	}



	public int getAtomOresLastIndex(){
		return atomOresNameListHash.sizeKeysList() / 16;
	}



	public int getAtomOresMetaOfLastIndex(){
		return atomOresNameListHash.sizeKeysList() - getAtomOresLastIndex() * 16;
	}



	public ListHash<String, String> getAtomOresName(){
		return atomOresNameListHash;
	}

}
