package pcc.chemicraft.base;

import pcc.chemicraft.base.item.ItemAtomsGrenade;
import pcc.chemicraft.base.item.ItemBlackSmoke;
import pcc.chemicraft.base.item.ItemDust;
import pcc.chemicraft.base.item.ItemRadiationBallet;
import pcc.chemicraft.base.item.ItemRadiationGun;

public class ChemiCraftRegisterItem extends ChemiCraftBaseRegister {

	public ChemiCraftRegisterItem(ChemiCraftBase mod) {
		super(mod);
	}

	@Override
	public void start() {
		/*
		 * 代入
		 */
		this.mod.itemAtomGrenade = new ItemAtomsGrenade(this.mod.atomGrenadeID).setItemName("grenade").setIconIndex(1);
		this.mod.itemDust = new ItemDust(this.mod.dustID).setItemName("dust").setIconIndex(12);
		this.mod.itemRadiationGun = new ItemRadiationGun(this.mod.radiationGunID).setIconIndex(4).setItemName("RadiationGun");
		this.mod.itemRadiationBallet = new ItemRadiationBallet(this.mod.radiationBalletID).setIconIndex(5).setItemName("RadiationBallet");
		this.mod.itemBlackSmoke = new ItemBlackSmoke(this.mod.blackSmokeID).setIconIndex(7).setItemName("BlackSmoke");

		/*
		 * 名前登録&Minecraftに登録
		 */
		this.mod.nameAuxiliary.addName(this.mod.itemAtomGrenade, "AtomGrenade");
		this.mod.nameAuxiliary.addName(this.mod.itemAtomGrenade, "ja_JP", "元素手榴弾");
		this.mod.nameAuxiliary.addName(this.mod.itemDust, "dust");
		this.mod.nameAuxiliary.addName(this.mod.itemDust, "ja_JP", "粉塵");
		this.mod.nameAuxiliary.addName(this.mod.itemRadiationGun, "RadiationGun");
		this.mod.nameAuxiliary.addName(this.mod.itemRadiationGun, "ja_JP", "放射線銃");
		this.mod.nameAuxiliary.addName(this.mod.itemRadiationBallet, "RadiationBallet");
		this.mod.nameAuxiliary.addName(this.mod.itemRadiationGun, "ja_JP", "放射線弾");
		this.mod.nameAuxiliary.addName(this.mod.itemBlackSmoke, "BlackSmoke");
		this.mod.nameAuxiliary.addName(this.mod.itemBlackSmoke, "ja_JP", "黒煙");
	}

}
