package pcc.chemicraft.base.gen;

import java.util.Random;

import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import cpw.mods.fml.common.IWorldGenerator;

public class WorldGenAtomsOre extends WorldGenMinable implements IWorldGenerator {

	private int frequency;
	private int posY;

	public WorldGenAtomsOre(int id, int meta, int size, int frequency, int posY) {
		super(id, meta, size);
		this.frequency = frequency;
		this.posY = posY;
	}

	public WorldGenAtomsOre(int id, int meta, int size, EnumOreSpawnFrequency frequency, int posY) {
		super(id, meta, size);
		this.frequency = frequency.getFrequency();
		this.posY = posY;
	}
	
	@Override
	public void generate(Random par1Random, int par2ChunkX, int par3ChunkZ, World par4World, IChunkProvider par5ChunkGenerator, IChunkProvider par6ChunkProvider) {
		for (int i = 0; i < this.frequency; i++) {
			this.generate(par4World, par1Random, par2ChunkX * 16 + par1Random.nextInt(16), par1Random.nextInt(this.posY), par3ChunkZ * 16 + par1Random.nextInt(16));
		}
	}

}
