package pcc.chemicraft.core.block;

import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import pcc.chemicraft.ChemiCraft;
import pcc.chemicraft.core.ChemiCraftCore;
import pcc.chemicraft.core.tileentity.TileEntityChemicalCombinationTable;

public class BlockChemicalCombinationTable extends BlockContainer {

	public BlockChemicalCombinationTable(int par1, int par2, Material par3Material) {
		super(par1, par2, par3Material);
		this.setCreativeTab(ChemiCraftCore.creativeTabChemiCraft);
	}

	@Override
	public boolean onBlockActivated(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
		par5EntityPlayer.openGui(ChemiCraftCore.instance, ChemiCraftCore.instance.guiChemicalCombinationTableID, par1World, par2, par3, par4);
		return true;
	}



	@Override
	public String getTextureFile() {
		return ChemiCraft.BLOCK_CHEMICAL_CRAFTING_TABLE_TEXTURE;
	}



	public void onNeighborBlockChange(World par1World, int par2, int par3, int par4, int par5) {
		if (!par1World.isRemote) {
			boolean var7 = par1World.isBlockIndirectlyGettingPowered(par2, par3, par4);
			if(var7) {
				TileEntityChemicalCombinationTable tileentity;
				try {
					tileentity = (TileEntityChemicalCombinationTable) par1World.getBlockTileEntity(par2, par3, par4);
				} catch(ClassCastException e) {
					return;
				}
				tileentity.setProvidePower(true);
			}
		}
	}



	@Override
	public int getBlockTextureFromSide(int par1) {
		if(par1 == 0){
			return 17;
		}else if(par1 == 1){
			return this.blockIndexInTexture;
		}else{
			return 16;
		}
	}

	@Override
	public TileEntity createNewTileEntity(World var1) {
		return new TileEntityChemicalCombinationTable();
	}

}
